<?php

namespace App\Services\Nati;

use App\Entities\Nati\Product;
use App\Entities\Nati\Stock;
use App\Entities\Nati\StockBalance;
use App\Entities\Nati\StockItemsMovimentation;
use App\Entities\Nati\StockMovimentation;
use App\Repositories\Nati\StockRepository;
use App\Validators\Nati\StockValidator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class AdjustStocksService
{
    public function getStocks()
    {
       return $stocks = DB::select("select * from est_estoques where flativo =1");
    }

    public function filterProducts($request)
    {
        $category = $request['categoria'];
        $filter = $request['filter'];
        $stock = $request['estoque'];
        $limit = $request['limit'];
        $page = $request['page'];

        $products = StockBalance::selectRaw(
            'est_estoques.stEstoque,
            prd_produtos.stProduto,
            est_saldos.nrQuantidade,
            est_saldos.idProduto,
            est_saldos.idEstoque,
            prd_medidas.flFracionado,
            prd_medidas.stMedida,
            prd_medidas.idMedida,
            MAX(prd_codigos.idCodigo) as idCodigo'
        )
            ->join('prd_produtos', 'est_saldos.idProduto', 'prd_produtos.idProduto')
            ->join('prd_codigos', 'prd_produtos.idProduto', 'prd_codigos.idProduto')
            ->join('prd_categorias', 'prd_produtos.idCategoria', 'prd_categorias.idCategoria')
            ->join('prd_medidas', 'prd_produtos.idMedida', 'prd_medidas.idMedida')
            ->join('est_estoques', 'est_saldos.idEstoque', 'est_estoques.idEstoque')
            ->where('prd_categorias.idCategoria', $category)
            ->where('prd_categorias.flAtivo', true)
            ->where('est_estoques.idEstoque', $stock)
            ->where(function ($query) use ($filter) {
                    $query->where('prd_Codigos.idCodigo', $filter)
                        ->orWhere('prd_Produtos.stProdutoAbreviado', 'LIKE', "%{$filter}%");
            })
            ->groupBy([
                'est_estoques.stEstoque',
                'prd_produtos.stProduto',
                'est_saldos.nrQuantidade',
                'est_saldos.idProduto',
                'est_saldos.idEstoque',
                'prd_medidas.flFracionado',
                'prd_medidas.stMedida',
                'prd_medidas.idMedida',
                'prd_codigos.idCodigo'
            ])
            ->orderBy('prd_codigos.idCodigo')
            ->paginate($limit, $page);

        return $products;
    }

    public function adjustStock($data)
    {
        $user = Auth::user();

        foreach ($data as $item) {
            $idProduto = $item['idProduto'];
            $idEstoque = $item['idEstoque'];
            $newQuantity = $item['newQuantity'];
            $diff = $item['newQuantity'] - $item['nrQuantidade'];
            $product = Product::where('idProduto', $idProduto)->first();
            try {
                $this->insertMovimentation($item);
            } catch (\Exception $exception) {
                throw $exception;
            }
            DB::statement("update est_saldos set nrQuantidade = $newQuantity where idEstoque = $idEstoque and idProduto = $idProduto");
            DB::statement("IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_Saldos' AND COLUMN_NAME = 'dtAlteracao') UPDATE est_Saldos SET dtAlteracao = GETDATE() WHERE idEstoque = '$idEstoque' AND idProduto = '$idProduto'");
            $this->removeIfDuplicated($idProduto, $idEstoque);
        }
    }

    public function insertMovimentation($data)
    {
        $user = Auth::user();
        $idMovimentacao = StockMovimentation::max('idMovimentacao') + 1;
        $idProduto = $data['idProduto'];
        $idEstoque = $data['idEstoque'];
        $newQuantity = $data['newQuantity'];
        $diff = $data['newQuantity'] - $data['nrQuantidade'];
        $product = Product::where('idProduto', $idProduto)->first();
        if ($diff > 0) {
            StockMovimentation::insert([
                'idMovimentacao' => $idMovimentacao,
                'idOrigem' => 0,
                'idDestino' => 1,
                'dtMovimentacao' => Carbon::now(),
                'stOperador' => $user->stApelido,
                'stNotaFiscal' => 'AJUSTE DE ESTOQUE',
                'flEntrada' => true,
                'flTipoOrigem' => true,
                'flTipoDestino' => true,
                'flAtivo' => true,
                'stObservacao' => 'AJUSTE DE ESTOQUE',
                'dtData' => Carbon::now(),
                'flTipoEstoque' => true
            ]);
            $idItem = StockItemsMovimentation::max('idItem') + 1;
            $custo = $diff * $product->vrCusto;
            DB::statement("insert into est_itensMovimentacao values (?, ?, 0, ?, ?, ?, 0, '', ?)", [
                $idItem,
                $idMovimentacao,
                $idProduto,
                $diff,
                $custo,
                Carbon::now(),
            ]);
        }
        if($diff < 0) {
            StockMovimentation::insert([
                'idMovimentacao' => $idMovimentacao,
                'idOrigem' => 0,
                'idDestino' => 1,
                'dtMovimentacao' => Carbon::now(),
                'stOperador' => $user->stApelido,
                'stNotaFiscal' => 'AJUSTE DE ESTOQUE',
                'flEntrada' => false,
                'flTipoOrigem' => true,
                'flTipoDestino' => true,
                'flAtivo' => true,
                'stObservacao' => 'AJUSTE DE ESTOQUE',
                'dtData' => Carbon::now(),
                'flTipoEstoque' => true
            ]);

            $idItem = StockItemsMovimentation::max('idItem') + 1;
            $custo = $diff * $product->vrCusto;
            DB::statement("insert into est_itensMovimentacao values (?, ?, 0, ?, ?, ?, 0, '', ?)", [
                $idItem,
                $idMovimentacao,
                $idProduto,
                $diff,
                $custo,
                Carbon::now(),
            ]);
        }
    }

    public function removeIfDuplicated($idProduto, $idEstoque = 1)
    {
        $balances = StockBalance::where('idEstoque', $idEstoque)
                    ->where('idProduto', $idProduto)
                    ->get();

        $count = count($balances);
        if($count > 1) {
            for ($i = 0; $i < $count; $i++) {
                if($i !== 0) {
                    StockBalance::where('idSaldo', $balances[$i]->idSaldo)->delete();
                }
            }
        }
    }
}
