<?php
/**
 * Created by PhpStorm.
 * User: Kaio F.
 * Date: 10/07/2017
 * Time: 15:55
 */

namespace App\Services\Nati;


use App\Entities\Nati\PrdConfig;
use App\Repositories\Nati\PrdConfigRepository;
use App\Validators\Nati\PrdConfigValidator;

class PrdConfigService {

    protected $repository;
    protected $validator;

    public function __construct(PrdConfigRepository $repository, PrdConfigValidator $validator) {

        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function config($request){

//        if (count(PrdConfig::all())){
//
//            PrdConfig::truncate();
//        }

        $data = [
            'idConfig'      => 1,
            'flDtAlteracao' => $request['flDtAlteracao'],
            'flCodigo' => 1,
            'flDesc' => $request['flDesc'],
            'flDescAbr' => $request['flDescAbr'],
            'flCategoria' => $request['flCategoria'],
            'flSubCategoria' => $request['flSubCategoria'],
            'flMedidaCompra' => isset($request['flMedidaCompra']) ?  $request['flMedidaCompra'] : 0,
            'flMedidaVenda' => $request['flMedidaVenda'],
            'flSetor' => $request['flSetor'],
            'flVrCompra' => $request['flVrCompra'],
            'flVrVenda' => $request['flVrVenda'],
            'flAliquota' => $request['flAliquota'],
            'flNCM' => $request['flNCM'],
        ];

        return $this->repository->update($data, 1);

    }

    public function all(){

        return $this->repository->all()->first();
    }
}
