<?php

namespace App\Validators\Nati;

use \Prettus\Validator\Contracts\ValidatorInterface;
use \Prettus\Validator\LaravelValidator;

class MicroTerminalValidator extends LaravelValidator
{

    protected $rules = [
        ValidatorInterface::RULE_CREATE => [

            'idMicroTerminal'       =>       'max:15|string|required',
            'stMicroTerminal'       =>       'max:20|string|required',
            'stTipo'                =>       'required',
            'nrPorta'               =>       'required',
            'nrTeclas'              =>       'required|numeric',
            'stBalanca'             =>       'required|string|max:15',
            'stTipoPorta'           =>       'required|max:50|string',
            'nrTabelaPreco'         =>       'required'

        ],
        ValidatorInterface::RULE_UPDATE => [

            'stMicroTerminal'       =>       'max:20|string',

        ],
   ];
}
