<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCliPagamentoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cli_Pagamento')) {
            Schema::create('cli_Pagamento', function(Blueprint $table){
                $table->bigInteger('idPagamento',false,true);
                $table->bigInteger('idAbertura',false,true);
                $table->bigInteger('idCliente', false, true);
                $table->integer('idOperador',false,true);
                $table->dateTime('dtData');
                $table->decimal('vrPagamento',9, 2);
                $table->integer('idFormaPagamento');
                $table->integer('idOperadorAutorizador');
                $table->boolean('flAtivo');
                $table->decimal('vrSaldoAnterior',9, 2);
                $table->integer('idFatura');
                $table->decimal('vrTroco',9, 2);
                $table->dateTime('dtAlteracao');
                $table->integer('idBanco');
                $table->decimal('nrCheque',18, 0);
                $table->decimal('nrAgenciaCheque',18, 0);
                $table->decimal('nrContaCheque',18, 0);
                $table->dateTime('dtDepositoCheque');

                $table->primary(['idPagamento','idAbertura']);
            });


        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cli_Pagamento');
    }
}
