<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxSangriasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Sangrias')) {
            Schema::create('cx_Sangrias', function (Blueprint $table) {

                $table->integer('idSangria');
                $table->integer('idAbertura');
                $table->integer('idOperador');
                $table->dateTime('dtData');
                $table->decimal('vrSangria', 9, 2);
                $table->integer('idFormaPagamento');
                $table->integer('idOperadorAutorizador');
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao');

                $table->primary(['idSangria', 'idAbertura']);
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Sangrias');

    }
}
