<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvFichaPagamentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_FichaPagamentos')) {
            Schema::create('dlv_FichaPagamentos', function (Blueprint $table) {
                $table->unsignedBigInteger('idFicha');
                $table->unsignedBigInteger('idAtendimento');

                $table->unsignedInteger('idFormaPagamento');

                $table->decimal('vrFormaPagamento', 18,2);
                $table->dateTime('dtData');
                $table->boolean('flTroco')->default(false);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao');

                $table->primary(['idFicha', 'idAtendimento']);

                $table->foreign('idFormaPagamento')
                    ->references('idFormaPagamento')
                    ->on('cx_FormasPagamento');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_FichaPagamentos');
    }
}
