<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('email')) {
            Schema::create('email', function (Blueprint $table) {
                $table->increments('id');
                $table->string('email', 75);
                $table->string('senha', 35);
                $table->string('servidor', 75);
                $table->string('porta', 6);
                $table->string('nome', 150);
                $table->string('seguranca', 6);
                $table->string('assunto', 500)->nullable(true);
                $table->string('corpo', 500)->nullable(true);
                $table->boolean('flLido');
                $table->dateTime('dtAlteracao');

            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email');

    }
}
