<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNatKeysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nat_Keys')) {
            Schema::create('nat_Keys', function (Blueprint $table) {
                $table->string('stIndex', 3);
                $table->string('stChave', 16);
                $table->string('stData', 8);
                $table->string('stTipo', 2);
                $table->string('stComponente', 50);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nat_Keys');
    }
}
