<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdAliquotasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Aliquotas')) {
            Schema::create('prd_Aliquotas', function (Blueprint $table) {
                $table->integer('idAliquota', false, true);
                $table->string('stAliquota', 8);
                $table->decimal('vrAliquota', 7, 2);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->string('Codigo', 8);
                $table->string('CstIcms', 3);
                $table->string('CstPis', 2);
                $table->string('CstCofins', 2);
                $table->string('CfopEntrada', 4);
                $table->string('CfopSaida', 4);
                $table->decimal('Iva', 7, 4);
                $table->decimal('AliquotaIcms', 7, 4);
                $table->decimal('AliquotaCofins', 7, 4);
                $table->decimal('AliquotaPis', 7, 4);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Aliquotas');

    }
}
