<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdFichaTecnicaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_FichaTecnica')) {

            DB::statement('CREATE TABLE [dbo].[prd_FichaTecnica](
                  [idProdutoPrincipal] [int] NOT NULL,
                  [idItem] [int] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [nrQuantidade] [decimal](9, 3) NOT NULL,
                  [vrCustoTotal] [decimal](9, 2) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_prd_FichaTecnica] PRIMARY KEY CLUSTERED
                    (
                      [idProdutoPrincipal] ASC,
                      [idItem] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_FichaTecnica');

    }
}
