<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

// var_dump($_GET);
$start = $_GET['start'];
$length = $_GET['length'];
$search = $_GET['search'];
$order = $_GET['order'][0];
$orderDirection = strtoupper($order['dir']);
if ($order) {
    $orderColumn = $order['column'];
    switch ($orderColumn) {
        case 0:
            $orderColumn = "p.idProduto";
            break;
        default:
        case 1:
            $orderColumn = "p.dtUltimaAlteracao";
            break;
        case 2:
            $orderColumn = "convert(decimal, c.idCodigo)";
            break;
        case 3:
            $orderColumn = "p.stProduto";
            break;
        case 4:
            $orderColumn = "p.stProdutoAbreviado";
            break;
        case 5:
            $orderColumn = "t.stCategoria";
            break;
        case 6:
            $orderColumn = "b.stSubCategoria";
            break;
        case 7:
            $orderColumn = "m.stMedida";
            break;
        case 8:
            $orderColumn = "mc.stMedida";
            break;
        case 9:
            $orderColumn = "s.stSetor";
            break;
        case 10:
            $orderColumn = "p.vrUnitario";
            break;
        case 11:
            $orderColumn = "p.vrCusto";
            break;
        case 12:
            $orderColumn = "a.stAliquota";
            break;
    }
}
$searchValue = $search['value'];
$searchLength = strlen($searchValue);
// }
$camposDeBusca = ['c.idCodigo', 't.stCategoria', 's.stSetor', 'b.stSubCategoria'];

//QUERY DE TOTAL DE PRODUTOS
$qry = "SELECT COUNT(DISTINCT c.idCodigo)FROM prd_Produtos p 
INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto 
WHERE p.flAtivo = '1'  AND p.idTipoProduto <> 7 ";
$res = mssql_fetch_array(mssql_query($qry));
$rows['recordsTotal'] = $res[0];


//QUERY DE TOTAL DE PRODUTOS FILTRADOS
$qry = "SELECT COUNT(DISTINCT c.idCodigo)FROM prd_Produtos p 
INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto 
INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida 
INNER JOIN prd_Medidas mc ON p.idMedidaCompra = mc.idMedida 
INNER JOIN prd_Categorias t ON p.idCategoria = t.idCategoria 
INNER JOIN prd_SubCategorias b ON p.idSubCategoria = b.idSubCategoria AND t.idCategoria = b.idCategoria 
INNER JOIN prd_Aliquotas a ON p.idAliquota = a.idAliquota 
INNER JOIN prd_Setores s ON p.idSetor = s.idSetor 
WHERE p.flAtivo = '1'  AND p.idTipoProduto <> 7 ";
if($searchLength > 0){
    $qry .= "AND p.stProduto LIKE '%".$searchValue."%'";
    for ($i=0; $i < count($camposDeBusca); $i++) {
        $qry .= "OR p.flAtivo = '1' AND p.idTipoProduto <> 7 and convert(decimal, c.idCodigo) > 0 ";
        $qry .= "AND ".$camposDeBusca[$i]." LIKE '%".$searchValue."%'";
    }
}
$res = mssql_fetch_array(mssql_query($qry));
$rows['recordsFiltered'] = $res[0];


//QUERY DE BUSCA DE PRODUTOS
$qry = "DECLARE @page INT = ".($start/$length)."
DECLARE @perPage INT = ".$length."

SELECT idCodigo, stProduto, stProdutoAbreviado, stCategoria, stSubCategoria, stMedida, stMedidaCompra, stSetor, vrCusto, vrUnitario, stAliquota, idProduto, dtUltimaAlteracao, nrNCM FROM
(
	SELECT ROW_NUMBER() OVER (ORDER BY ".$orderColumn." ".$orderDirection.") AS RowNum, idCodigo, stProduto, p.stProdutoAbreviado, m.stMedida, mc.stMedida as stMedidaCompra, a.stAliquota, t.stCategoria, p.vrCusto, p.vrUnitario, p.idProduto, s.stSetor, p.idSubCategoria, b.stSubCategoria, p.dtUltimaAlteracao, p.nrNCM
	FROM prd_Produtos p
	INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
	INNER JOIN prd_Medidas mc ON p.idMedidaCompra = mc.idMedida
	INNER JOIN prd_Categorias t ON p.idCategoria = t.idCategoria 
	INNER JOIN prd_SubCategorias b ON p.idSubCategoria = b.idSubCategoria AND t.idCategoria = b.idCategoria 
	INNER JOIN prd_Aliquotas a ON p.idAliquota = a.idAliquota 
	INNER JOIN prd_Setores s ON p.idSetor = s.idSetor 
	WHERE p.flAtivo = '1' AND p.idTipoProduto <> 7 and convert(decimal, c.idCodigo) > 0 ";
if($searchLength > 0){
    $qry .= "AND p.stProduto LIKE '%".$searchValue."%'";
    for ($i=0; $i < count($camposDeBusca); $i++) {
        $qry .= "OR p.flAtivo = '1' AND p.idTipoProduto <> 7 and convert(decimal, c.idCodigo) > 0 ";
        $qry .= "AND ".$camposDeBusca[$i]." LIKE '%".$searchValue."%'";
    }
}
$qry .= ") AS produtos WHERE RowNum >= (@page)* @perPage AND RowNum <= ((@page)* @perPage)+@perPage";
// var_dump($qry);
$res = mssql_query($qry);
while ($arr = mssql_fetch_assoc($res)) {
    $prd['flDtAlteracao'] = date("d/m/Y H:i", strtotime($arr['dtUltimaAlteracao']));
    $prd['flCodigo'] = $arr['idCodigo'];
    $prd['flDesc'] = utf8_encode($arr['stProduto']);
    $prd['flDescAbr'] = utf8_encode($arr['stProdutoAbreviado']);
    $prd['flCategoria'] = utf8_encode($arr['stCategoria']);
    $prd['flSubCategoria'] = utf8_encode($arr['stSubCategoria']);
    $prd['flMedidaVenda'] = $arr['stMedida'];
    $prd['flMedidaCompra'] = $arr['stMedidaCompra'];
    $prd['flSetor'] = utf8_encode($arr['stSetor']);
    $prd['flVrCompra'] = number_format($arr['vrCusto'],2, ",", ".");
    $prd['flVrVenda'] = number_format($arr['vrUnitario'],2, ",", ".");
    $prd['flAliquota'] = $arr['stAliquota'];
    $prd['flNCM'] = $arr['nrNCM'];
    $prd['flIdProduto'] = $arr['idProduto'];
    $data[] = $prd;
}
if (!$data) {
    $rows['data'] = array();
}else{
    $rows['data'] = $data;
}

echo json_encode($rows);
?>
