<?php


header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'vendasPorCliente':
            relatorioVendas($_POST['idCliente'], $_POST['dataInicial'], $_POST['dataFinal']);
        break;
        case 'listaClientes':
            listaClientes($_POST['dataInicial'], $_POST['dataFinal']);
        break;
        case 'voucher':
            voucher($_POST['dataInicial'], $_POST['dataFinal']);
            break;
	}
}


function queryItens($data = array(), $idCliente)
{
    $query = "SELECT i.dtData, i.idCodProduto, i.idProduto, p.stProduto, m.flFracionado, m.stMedida, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal - i.vrDesconto) as vrTotal
                       FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
                       INNER JOIN prd_Produtos p ON i.idProduto = p.idProduto
                       INNER JOIN (SELECT p.idProduto, p.idMedida, m.stMedida, m.flFracionado FROM prd_Produtos p INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida) m  ON i.idProduto = m.idProduto
                       INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
                       INNER JOIN (SELECT idVenda, idAbertura, idCliente FROM cx_Vendas UNION SELECT idVenda, idAbertura, idCliente FROM cx_Vendas_Temp) v ON i.idVenda = v.idVenda AND i.idAbertura = v.idAbertura
                       INNER JOIN dlv_Clientes cl ON v.idCliente = cl.idCliente
                       WHERE i.flAtivo = '1' AND v.idCliente = ". $idCliente ." AND i.dtData BETWEEN '". $data['dataInicial'] ."' AND '". $data['dataFinal'] ."'
                       GROUP BY i.dtData, i.idCodProduto, i.idProduto, p.stProduto, m.stMedida, m.flFracionado
                       ORDER BY i.dtData";

    return $query;
}

function queryIdCliente($idCliente = NULL, $data = array())
{
    if ($idCliente == NULL || $idCliente == '')
    {
        $query = "select DISTINCT(v.idCliente), c.stCliente FROM
	          (SELECT idCliente, dtData FROM cx_Vendas UNION SELECT idCliente, dtData FROM cx_Vendas_Temp ) v
              INNER JOIN dlv_Clientes c on c.idCliente  = v.idCliente
              where v.idCliente > 0 and v.dtData BETWEEN '". $data['dataInicial'] ."' AND '". $data['dataFinal'] ."'
              ORDER BY c.stCliente ASC";
    }
    else
    {
        $query = "SELECT * FROM dlv_clientes WHERE idCliente = ". $idCliente;
    }

    return $query;
}

function queryVoucher($data = array()){

    $query = "SELECT V.*, CONCAT(v.idOperador, ' - ', op.stApelido) as stOperador, CONCAT(v.idOperadorAutorizador, ' - ', op.stApelido) as stAutorizador  FROM cx_Vaucher V
			INNER JOIN op_Operadores O
			ON V.idOperador = O.idOperador 
			INNER JOIN op_Operadores OP
			ON V.idOperadorAutorizador = OP.idOperador 
			WHERE V.flAtivo = 1 AND dtEmissao BETWEEN '". $data['dataInicial'] ."' AND '". $data['dataFinal'] ."'";

    return $query;
}

function relatorioVendas($idCliente ,$dataInicial, $dataFinal)
{
    $dt = sqlDate($dataInicial, $dataFinal);

    //monta a query para buscar os clientes que
    // possuem compras no periodo informa
    $query = queryIdCliente($idCliente, $dt);
    $res = mssql_query($query);

    //lista que sera retornada para a view
    $result = array();

    //percorre a lista de clientes

    $arr = @mssql_fetch_array($res);

    $result['idCliente'] = $arr['idCliente'];
    $result['cliente'] = $arr['stCliente'];

    //query para buscar os itens da venda
    $queryItens = queryItens($dt, $arr['idCliente']);

    $res1 = mssql_query($queryItens);

    $itens = [];
    //percorre a lista de itens
    while ($item = @mssql_fetch_array($res1))
    {
            $nrQuantidade = $item['flFracionado']
                ? number_format(($item['nrQuantidade'] / 1000), 3, ".", "")
                : $item['nrQuantidade'];

            $it = array(
                'data' => date("d/m/Y H:i", strtotime($item['dtData'])),
                'idCodProduto'  => $item['idCodProduto'],
                'stProduto'     => $item['stProduto'],
                'stMedida'      => $item['stMedida'],
                'nrQuantidade'  => $nrQuantidade,
                'vrTotal'       => number_format($item['vrTotal'], 2, ".", "")
                );

            //insere o item na lista
            array_push($itens, $it);
    }

    $result['itens'] = $itens;
    echo json_encode($result);
}


function listaClientes($dataInicial, $dataFinal)
{
    $data = sqlDate($dataInicial, $dataFinal);

    $query = queryIdCliente(null, $data);

    $res = mssql_query($query);

    $clientes = array();
    while ($row = @mssql_fetch_array($res))
    {
        $cli = array(
            'idCliente' => $row['idCliente'],
            'stCliente' => $row['stCliente']
        );
        $clientes[] = $cli;
    }

    echo json_encode($clientes);
}

function voucher($dataInicial, $dataFinal)
{
    $data = sqlDate($dataInicial, $dataFinal);

    $query = queryVoucher($data);

    $res = mssql_query($query);

    while ($arr = mssql_fetch_assoc($res)) {
        $arr['dtAlteracao'] = date("d/m/Y H:i", strtotime($arr['dtAlteracao']));
        $arr['dtEmissao'] = date("d/m/Y H:i", strtotime($arr['dtEmissao']));
        $arr['flLiquidado'] = $arr['flLiquidado'] == 1 ? 'LIQUIDADO' : 'NÃO UTILIZADO';
        $result[] = $arr;
    }
    echo json_encode($result);
}

?>