<?php
require_once '../functions.php';
db_conn();
?>
<html>
    <head>
        <title>.:: Importação - Saldos de Produtos ::.</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style type="text/css">
            body {
                background-color: #F4F4F4;
            }
            table {
                background-color: #fff;
            }
            table tr:hover {
                background-color: #000;
                color: #fff;
            }
            table tr td {
                text-align: center;
            }
            table th {
                background-color: #E2F0F9;
                border: 2px solid #2A98D3;
            }
            h2 {
                border: 1px solid #2A98D3;
                background-color: #E2F0F9;
                text-align: center;
                font-weight: bold;
                display: block;
                width: 500px;
            }
        </style>
    </head>
    <body>
        <center>
            <h2>Importação Saldos - Produtos TXT</h2>

            <?php
                if($_SERVER['REQUEST_METHOD'] == "GET") :
            ?>
            <form name="exportaProdutos" method="post" enctype="multipart/form-data" onsubmit="return fncValidaUpload(this);">
                <input type="file" name="txtFile" /><br />
                <input type="submit" value="Iniciar Importação" />
            </form>
            <?php elseif($_SERVER['REQUEST_METHOD'] == "POST") :

                move_uploaded_file($_FILES['txtFile']['tmp_name'], getcwd()."\\tmp\\".$_FILES['txtFile']['name']);
                $fl = fopen(getcwd()."\\tmp\\".$_FILES['txtFile']['name'], "r");
                $IDS = "";
                $SALDOS = array();
                while($linha = fgets($fl)){
                    $LINHA = explode(";", trim($linha));
                    if(isset($LINHA[0]) && is_numeric($LINHA[0]) && isset($LINHA[1]) && is_numeric($LINHA[1])) :
                        $IDS .= $LINHA[0].",";
                        $SALDOS[$LINHA[0]] = $LINHA[1];
                    endif;
                }
                fclose($fl);
                unlink(getcwd()."\\tmp\\".$_FILES['txtFile']['name']);

                if(empty($IDS)) :
                    echo 'Não foi encontrado produtos válidos neste arquivo importado.';
                    exit;
                endif;
            ?>
            <a href="">Voltar</a>
            <br /><br />
            <form method="post" onsubmit="return window.opener.fncValidaImportacaoSaldos(this);" action="importainventario.php">
                <center>
                    <input type="submit" name="btnAtualizar" value="Atualizar Saldos" />
                    <input type="button" onclick="window.close();" value="Fechar" />

                    <br /><br />Data da Converência: <input type="text" name="txtDataConferencia" value="<?php echo date("d/m/Y H:i:s")?>"/><br /><br />

                <table>
                    <thead>
                        <th>Importar?</th>
                        <th>Controlar Estoque?</th>
                        <th>ESTOQUE</th>
                        <th>CODIGO</th>
                        <th>PRODUTO</th>
                        <th>QNT. ATUAL</th>
                        <th>QNT. NOVA</th>
                        <th>MEDIDA COMPRA</th>
                    </thead>
                    <tbody>
                        <?php
                            $sql_produtos = "SELECT DISTINCT MAX(c.idCodigo) as idCodigo, p.stProdutoAbreviado, s.nrQuantidade, m.stMedida, s.idSaldo, e.stEstoque
                                                FROM prd_Produtos p
                                                INNER JOIN prd_Codigos c
                                                ON p.idProduto = c.idProduto
                                                LEFT JOIN est_Saldos s
                                                ON p.idProduto = s.idProduto
                                                LEFT JOIN est_Estoques e
                                                ON s.idEstoque = e.idEstoque
                                                LEFT JOIN prd_Medidas m
                                                ON p.idMedidaCompra = m.idMedida
                                                WHERE c.idCodigo IN(".substr($IDS, 0, (strlen($IDS) - 1)).") AND p.flAtivo = '1'AND e.idEstoque = 1
                                                GROUP BY p.stProdutoAbreviado, s.nrQuantidade, m.stMedida, s.idSaldo, e.stEstoque
                                                ORDER BY p.stProdutoAbreviado ASC";

                            $objResource = mssql_query($sql_produtos);
                            while($Prod = mssql_fetch_object($objResource)) :
                        ?>
                        <tr>
                            <input type="hidden" name="txtCodigo[<?php echo $Prod->idCodigo?>]" value="<?php echo str_replace(",", ".", $SALDOS[$Prod->idCodigo])?>" />
                            <td><?php if(!is_null($Prod->idSaldo)) : ?><input type="checkbox" name="chkImportacao[]" checked="checked" value="<?php echo $Prod->idCodigo?>" /><?php endif; ?></td>
                            <td><?php if(is_null($Prod->idSaldo)) : ?><input type="checkbox" name="chkControla[]" checked="checked" value="<?php echo $Prod->idCodigo?>" /><?php endif; ?></td>
                            <td><?php echo $Prod->stEstoque?></td>
                            <td><?php echo $Prod->idCodigo?></td>
                            <td><?php echo $Prod->stProdutoAbreviado?></td>
                            <td><?php echo (is_null($Prod->nrQuantidade) ? 'NCE' : $Prod->nrQuantidade)?></td>
                            <td><?php echo str_replace(",", ".", $SALDOS[$Prod->idCodigo])?></td>
                            <td><?php echo $Prod->stMedida?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>

                    <input type="submit" name="btnAtualizar" value="Atualizar Saldos" />
                    <input type="button" onclick="window.close();" value="Fechar" />
                </center>
            </form>
            <?php else : ?>
            <h3>Tipo de requisição desconhecida!!</h3>
            <?php endif; ?>
        </center>
    <script type="text/javascript">
        window.opener.$(window.document).ready(function(){
            window.opener.$("input[name='txtDataConferencia']", window.document).mask("99/99/9999 99:99:99");
        });
    </script>
    </body>
</html>
