<?php

namespace App\Console\Commands;

use App\Entities\Delivery\Order;
use App\Entities\Master;
use Carbon\Carbon;
use Illuminate\Console\Command;

class BloqueiaPedido extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bloqueia:pedido';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $masterConfigs = Master::first();

        if($masterConfigs['flBloquearPedidosDeliveryInativos']) {
            $orders = Order::where('dtConclusao', '<=', Carbon::now()->subDays(5))
                ->where('flAtivo', true)
                ->where('flAgendarPedido', false)
                ->orWhere(function ($query) {
                    $query->where('stStatus', 'S')
                        ->where('stStatus', 'P');
                })
                ->get();

            foreach ($orders as $order) {
                $order->flAtivo = false;
                $order->dtAlteracao = Carbon::now();
                $order->stOBS .= 'ENCERRADO AUTOMATICAMENTE PELO SISTEMA';

                $order->save();
            }
        }
    }
}
