<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;

use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Measure extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_Medidas';
    protected $primaryKey = 'idMedida';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idMedida',
        'stMedida',
        'flFracionado',
        'flAtivo',
        'dtAlteracao',
        'stDescricao',
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flFracionado' => 'boolean',
    ];

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idMedida');
    }

    public function generateTags(): array
    {
        return [
            'product'
        ];
    }

    protected $auditExclude = [
        'dtAlteracao',
    ];
}
