<?php

namespace App\Entities;

use App\Entities\Nati\Customer;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use Ramsey\Uuid\Uuid;

class Sale extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Vendas';
    protected $primaryKey = ['idVenda', 'idAbertura', 'idFicha'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idVenda',
        'idAbertura',
        'vrTotal',
        'flNotaFiscal',
        'dtData',
        'idCliente',
        'vrDesconto',
        'vrAcrescimo',
        'flAtivo',
        'nrTempoAtendimento',
        'idOperadorAutorizador',
        'stFraseCupom',
        'flDelivery',
        'idAtendimentoDelivery',
        'stContaAssinada',
        'dtAlteracao',
        'nrCOO',
        'stCPF',
        'uuid',
        'chave_fiscal'
    ];

    protected $casts = [
        'idVenda' => 'integer',
        'idAbertura' => 'integer',
        'flNotaFiscal' => 'boolean',
        'flAtivo' => 'boolean',
        'flDelivery' => 'boolean',
        'vrAcrescimo' => 'float',
        'vrDesconto' => 'float',
        'vrTotal' => 'float',
    ];

    public function abertura()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'idCliente', 'idCliente');
    }

    public function itens()
    {
        return $this->hasMany(Items::class, 'idVenda', 'idVenda');
    }
    public function detalhes()
    {
        return $this->hasOne(SaleDetails::class, 'idVenda', 'idVenda');
    }
    public function pagamentos()
    {
        return $this->hasMany(ReceiptForm::class, 'idVenda', 'idVenda')
            ->where('idAbertura', $this->idAbertura);
    }


    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $model->uuid = (string)Uuid::generate(4);
        });
    }
}
