<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Financeiro\ContasReceberView;
use App\Http\Controllers\Controller;
use App\Services\ContasReceberService;
use Illuminate\Database\Eloquent\ModelNotFoundException;

use Illuminate\Http\Request;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\ContasReceberCreateRequest;
use App\Http\Requests\ContasReceberUpdateRequest;


class ContasReceberController extends Controller
{

    protected $service;


    public function __construct(ContasReceberService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        try
        {
            $result = $this->service->get($request->query());

            return response()->json($result);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

//    public function dataTable()
//    {
//        $contasReceber = ContasReceberView::with('clientes')->where('flAtivo', '=', 1);
//
//        return Datatables::of($contasReceber)
//            ->editColumn('dtLancamento', function ($contaReceber) {
//                return date("d/m/Y", strtotime($contaReceber['dtLancamento']));
//            })
//            ->editColumn('dtVencimento', function ($contaReceber) {
//                return date("d/m/Y", strtotime($contaReceber['dtVencimento']));
//            })
//            ->addColumn('action', function($contaReceber){
//                return '
//                  <a onClick="editarContaReceber('.$contaReceber->idContasReceber.','.$contaReceber->idCliente.')" class="col-sm-2 col-sm-offset-2 col-md-offset-2 col-md-4" style="cursor:pointer"><span class="glyphicon glyphicon-edit" style="font-size:1.5em"></span></a>
//                  <a onClick="desativarContaReceber('.$contaReceber->idContasReceber.','.$contaReceber->idCliente.')" class="col-sm-2 col-md-4" style="cursor:pointer"><span class="glyphicon glyphicon-remove" style="font-size:1.5em"></span></a>';
//            })->make(true);
//    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ContasReceberCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(ContasReceberCreateRequest $request)
    {
        try {
            $contasReceber = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Contas a Receber created',
                'data' => $contasReceber
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function view($idContasReceber, $idCliente)
    {
        try
        {
            $contasReceber = $this->service->getById($idContasReceber, $idCliente);

            return response()->json([
                'data' => $contasReceber,
            ],200);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    public function atualizar(ContasReceberUpdateRequest $request, $idContasReceber, $idCliente)
    {

        try {
            $response = $this->service->update($request->all(), $idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function delete($idContasReceber, $idCliente)
    {
        try {
            $response = $this->service->delete($idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Conta Receber removida',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }
}
