<?php


namespace App\Imports;


use App\Entities\Nati\Product;
use App\Services\Nati\ProductService;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ProductsImport implements ToCollection, WithHeadingRow
{
    /**
     * @var ProductService
     */
    protected $service;

    public function __construct(ProductService $service)
    {
        $this->service = $service;
    }
//    public function model(array $row)
//    {
//        $data = [
//            'stProduto' =>$row[0]
//        ];
//        return new Product($data);
//    }


    public function collection(Collection $rows)
    {
        $data = [];
        foreach ($rows as $row) {

            if (!$row['codigo_interno'])
                return;
            $temp = [
                'codigo' => $row['codigo_interno'],
                'ean' => $row['codigo_de_barras'],
                'descricao' => $row['descricao'],
                'preco' => $row['preco_de_venda'],
                'custo' => $row['preco_de_custo'],
                'margem' => $row['margem_de_lucro'],
                'categoria' => $row['categoria'],
                'setor' => $row['setor'],
                'ncm' => $row['ncm'],
                'cest' => $row['cest'],
            ];
            $this->service->import($temp);
        }
    }

    public function headingRow(): int
    {
        return 1;
    }
}
