<?php

namespace App\Repositories;

use App\Entities\Delivery\Order;
use App\Validators\Delivery\OrderValidator;
use Prettus\Repository\Criteria\RequestCriteria;
use Prettus\Repository\Eloquent\BaseRepository;

/**
 * Interface ContaBancariaRepository
 * @package namespace App\Repositories;
 */
class DlvOrderRepositoryEloquent extends BaseRepository implements DlvOrderRepository
{
    //
    /**
     * @inheritDoc
     */
    public function model()
    {
        return Order::class;
    }

    /**
     * Specify Validator class name
     *
     * @return mixed
     */
    public function validator()
    {
        return OrderValidator::class;
    }

    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
