<?php

namespace App\Services\Nati;

use App\Entities\Master;
use App\Entities\Nati\OrderDevice;
use App\Entities\Nati\OrderTab;
use App\Services\Service;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class OrderTabIntegracaoService extends Service
{

    /**
     * @param string $tabId
     * @return array
     * @throws Exception
     */
    public function check(string $tabId)
    {
        $master = Master::first();
        $letra = $master->stLetraComanda;
        $tipo = $master->stTipoComanda;
        $num = $master->nrDigitosComanda;
        $com = explode("@", $master->stMesas);
        $inicio = $com[0];
        $fim = $com[1];
        $countComanda = strlen($tabId);

        if ($countComanda < $num) {
            $add = '';
            $cont = $num - $countComanda;
            for ($i = 0; $i < $cont; $i++) {
                $add .= '0';
            }
            $tabId = substr($tabId, 0, 1) . $add . substr($tabId, 1, $countComanda - 1);
        }
        if (strtoupper(substr($tabId, 0, 1)) != $letra) {
            throw new Exception("incorrect letter");
        }
        switch ($tipo) {
            case "WDDDV":
                $nrComanda = substr($tabId, 1, stripos($num, $letra) - 1);
                break;
            case "WDDD":
                $nrComanda = substr($tabId, stripos($num, $letra) + 1);
                break;
            default:
                $nrComanda = false;
        }
        if ($nrComanda == false) {
            throw new Exception("invalid ordertab");
        }
        if ($nrComanda < $inicio || $nrComanda > $fim) {
            throw new Exception("invalid ordertab number");
        }
        if (!$this->checkVerifyId($tabId, $tipo, $num)) {
            throw new Exception("invalid verify number");
        }

        return [
            'tab' => $tabId,
            'startParameter' => $letra,
            'digit' => $tipo == "WDDDV" ? substr($tabId, -1) : "0"
        ];
    }

    /**
     * @param string $tabId
     * @param string $deviceId
     * @return Builder|Builder[]|Collection|Model|null
     * @throws Exception
     */
    public function show(string $tabId, string $deviceId)
    {
        $this->check($tabId);
        $tipo = Master::first()->stTipoComanda;
        switch ($tipo) {
            case "WDDDV":
                $tabId = substr($tabId, 1, strlen($tabId) - 2);
                break;
            case "WDDD":
                $tabId = substr($tabId, 1);
                break;
        }
        if (!OrderDevice::where('idMicroTerminal', $deviceId)->exists()) {
            throw new Exception("incorrect deviceId");
        }
        return OrderTab::with('items')->find($tabId);
    }

    /**
     * @param string $tabId
     * @param string $deviceId
     * @throws Exception
     */
    public function unlock(string $tabId, string $deviceId)
    {
        $this->check($tabId);
        $tipo = Master::first()->stTipoComanda;
        switch ($tipo) {
            case "WDDDV":
                $tabId = substr($tabId, 1, strlen($tabId) - 2);
                break;
            case "WDDD":
                $tabId = substr($tabId, 1);
                break;
        }
        $tab = OrderTab::where('idComanda', $tabId)->get()->first();
        if ($tab == null) {
            throw new Exception("incorrect tabId");
        }
        if ($tab->idMicroterminallock != strtoupper($deviceId)) {
            throw new Exception("incorrect deviceId");
        }
        $tab->flBloqueada = false;
        $tab->idMicroterminallock = '';
        $tab->stOperadorlock = ''; //TODO Implements
        $tab->save();
    }

    /**
     * @param string $tabId
     * @param string $deviceId
     * @throws Exception
     */
    public function lock(string $tabId, string $deviceId)
    {
        $this->check($tabId);
        $tipo = Master::first()->stTipoComanda;
        switch ($tipo) {
            case "WDDDV":
                $tabId = substr($tabId, 1, strlen($tabId) - 2);
                break;
            case "WDDD":
                $tabId = substr($tabId, 1);
                break;
        }
        if (!OrderDevice::where('idMicroTerminal', $deviceId)->exists()) {
            throw new Exception("incorrect deviceId");
        }
        $tab = OrderTab::find($tabId);
        $tab->flBloqueada = true;
        $tab->idMicroterminallock = strtoupper($deviceId);
        $tab->stOperadorlock = Auth::user()->stOperador;
        $tab->save();
    }

    /**
     * @param $orderPad
     * @param $type
     * @param $numberDigits
     * @return bool
     */
    public function checkVerifyId($orderPad, $type, $numberDigits)
    {
        $value = preg_replace('/[^0-9]/', '', $orderPad);
        if (strlen($value) < 2) {
            return false;
        }

        $numeral = substr($value, 0, strlen($value) - 1);
        $digit = substr($value, strlen($value) - 1);

        $sum = 0;
        $multiply = 2;

        switch ($type) {
            case "WDDD":
            {
                return true;
                break;
            }
            case "WDDDVE":
                $multiply = 3;
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sum += intval($numeral[$i - 1]) * intval($multiply);
                    $multiply = ($multiply == 3 ? 1 : 3);
                }
                $sum = 10 - ($sum % 10);
                if ($sum == 10) $sum = 0;
                break;
            case "WDDDV11":
            {
                $multiply = 2;
                $sum = 0;
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sum += intval($numeral[$i - 1]) * intval($multiply);
                    $multiply++;
                }
                $sum = (intval($sum) * 10) % 11;

                if ($sum == 10) $sum = 0;
                return $sum == intval($digit);
            }
            default:
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sum += $numeral[$i - 1] * $multiply;
                    $multiply++;
                }
                $sum = (intval($sum) * 10) % 11;
                $sum += -2;

                if ($sum < 0) {
                    if ($sum == -1) $sum = 0;
                    if ($sum == -2) $sum = 9;
                }
                break;
        }
        if ($sum == $digit) {
            return true;
        }
        $orderPad = "7" . str_pad($numeral, intval($numberDigits) - 2, '0', STR_PAD_LEFT);
        $multiply = 2;
        $sum = 0;

        for ($i = strlen($orderPad); $i > 0; $i--) {
            $sum += intval($orderPad[$i - 1]) * intval($multiply);
            $multiply++;
        }
        $sum = (intval($sum) * 10);
        $sum = intval($sum) % 11;
        //$sum += -2;
        if ($sum == 10) {
            $sum = 0;
        }
        return $sum == $digit;
    }
}
