<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvCEPsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_CEPs')) {
            Schema::create('dlv_CEPs', function (Blueprint $table) {
                $table->integer('idCEP', false,true);
                $table->string('stCEP',8);
                 $table->string('stEndereco',75);
                 $table->string('stBairro',65);
                 $table->string('stCidade',25);
                 $table->string('stEstado',2);
                 $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_CEPs');
    }
}
