var vrAberturaF;
var vrSangriaF;
var depContaF;
var vrDespesaF;
var idDinheiro;
var idAbertura;
var depContaDinheiro;

flSomaAbertura = false;

document.addEventListener("DOMContentLoaded", function () {

    $(document).on('click', '#btn-dinheiro', function () {
        $('.collapseDinheiro').collapse('toggle');
    })

    // Eventos do Collapse de dinheiro (sem animação original)
    $(document).on('hide.bs.collapse', '.collapseDinheiro', function () {
        $('#btn-dinheiro').find('i').removeClass('glyphicon glyphicon-minus');
        $('#btn-dinheiro').find('i').addClass('glyphicon glyphicon-plus');
        $(this).animate({height: '0px', opacity: 0}, 180)
        $('.inputDinamico').appendTo('.trDinheiro');
        $('dinamico').remove('.inputDinamico');

    })
    $(document).on('show.bs.collapse', '.collapseDinheiro', function () {
        $('#btn-dinheiro').find('i').removeClass('glyphicon glyphicon-plus');
        $('#btn-dinheiro').find('i').addClass('glyphicon glyphicon-minus');
        $(this).animate({height: '0px', opacity: 1}, 180)
        $('.inputDinamico').appendTo('.dinamico');
        $('.trDinheiro').remove('.inputDinamico');
    })

    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    var pagina = $("#idPagina").val();
    var data = {
        action: "initPage"
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (!response.status) {
            toastr.error(response.msg);
        } else {
            data = {
                action: "getTurnos"
            };
            $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
                if (response) {
                    $('#selectTurnos').append($("<option></option>").attr("value", 0).attr("selected", "selected").text('Todos'));
                    for (var i = 0; i < response.length; i++) {
                        $('#selectTurnos').append($("<option></option>").attr("value", response[i].idTurno).text(response[i].stDescricao +
                            '(' + response[i].hrInicio + ' até ' + response[i].hrFim + ')'));
                    }
                    $('#divTurnos').removeClass('hidden');
                }
            });
        }
    });
    if (pagina == "fechamento") {
        getFechamentosInit();
    } else if (pagina == "caixa") {
        getCaixasInit();
    }

    $("#verSangria").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        var data = {
            action: "getSangria",
            idAbertura: idAbertura
        };
        console.log("verSangria.data: ", data);
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response) {
                var vrTotal = 0;

                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    vrTotal += parseFloat(response[i].vrSangria);
                    linha += '<tr><td style="tdStyle">' + response[i].stApelido + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrSangria).toFixed(2) + '</td></tr>';
                }
                linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhuma Sangria para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divSangria"));
        });
    });

    $("#verSuprimento").on("show.bs.modal", function () {
        var data = {
            action: "getSuprimento",
            idAbertura: idAbertura
        };
        console.log("verSuprimento.data: ", data);
        var vrTotal = 0;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response) {
                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    vrTotal += parseFloat(response[i].vrSangria);
                    linha += '<tr><td style="tdStyle">' + response[i].stApelido + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrSangria).toFixed(2) + '</td></tr>';
                }
                linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum Suprimento para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divSuprimento"));
        });
    });

    $("#verDespesas").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        var data = {
            action: "getDespesas",
            idAbertura: idAbertura
        };
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                $("body").removeClass("loading");
                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Despesa</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Forma</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    vrTotal += parseFloat(response[i].vrDespesa);
                    linha += '<tr><td style="tdStyle">' + response[i].stDescricao + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrDespesa).toFixed(2) + '</td></tr>'
                }
                linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
            } else {
                $("body").removeClass("loading");
                var linha = '<h4><b>Nenhuma Despesa para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divDespesas"));
            $("body").removeClass("loading");
        });
    });

    $("#verCaixaNoDia").on("show.bs.modal", function () {
        var id = $("#idOperador").val();
        var idCaixa = $("#idCaixa").val();
        var dtAbertura = $("#horaAbertura").html();
        var data = {
            action: "getCaixaNoDia",
            idOperador: id,
            idCaixa: idCaixa,
            dtAbertura: dtAbertura
        };
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table id="tableAberturaCaixa" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><caption class="table-caption"><h4>Aberturas do Caixa ' + response[0].idcaixa + ' no dia ' + response[0].data_acao + '</h4></caption><thead><tr><td class="tdStyle"><b></b></td><td class="tdStyle"><b>Operador</b></td><td class="tdStyle"><b>Status</b></td><td class="tdStyle"><b>Descricao</b></td><td class="tdStyle"><b>Hora</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td style="tdStyle" align="center">' + i + '</td><td style="tdStyle" align="center">' + response[i].operador + '</td><td style="tdStyle" align="center">' + response[i].status + '</td><td style="tdStyle" align="center">' + response[i].descricao + '</td><td style="tdStyle" align="center">' + response[i].hora_acao + '</td></tr>'
                }
            } else {
                var linha = '<h4><b>Nenhuma abertura para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divCaixaNoDia"));
            $("body").removeClass("loading");
        });
    });

    $("#verContaAssinada").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        // console.log(id);
        var data = {
            action: "getContaAssinada",
            idAbertura: idAbertura
        };
        console.log('verContaAssinada.data: ', data);
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            console.log('response: ', response)
            if (response) {
                for (var i = 0; i < response.length; i++) {
                    var vrTotal = 0.00;
                    var flQuit = true;
                    var flDesc = true;
                    var flCliente = true;
                    var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse">';
                    linha += '<thead><tr><td class="tdStyle" colspan="2" width="80%"><b>' + response[i].stCliente + ' </b></td><td class="tdStyle" width="20%"><b>' + response[i].dtData + ' </b></td></tr></thead><tbody>';
                    for (var j = 0; j < response[i].childs.length; j++) {
                        if (flCliente) {
                            if (response[i].childs[j].vrQuitado > "0.00" && flQuit) {
                                linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR QUITADO</b></td><td class="tdStyle" width="20%"><b>' + parseFloat(response[i].childs[j].vrQuitado).toFixed(2) + ' </b></td></tr>';
                                flQuit = false;
                            }
                            if (response[i].childs[j].vrDesconto != "0.00" && flDesc) {
                                linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>DESCONTO</b></td><td class="tdStyle" width="20%"><b>' + parseFloat(response[i].childs[j].vrDesconto).toFixed(2) + ' </b></td></tr>'
                                flDesc = false;
                            }
                            flCliente = false;
                        }
                        vrTotal += parseFloat(response[i].childs[j].vrTotal);
                        linha += '<tr><td class="tdStyle" width="60%">' + response[i].childs[j].stProduto + '</td><td class="tdStyle" width="20%">' + response[i].childs[j].nrQuantidade + " " + response[i].childs[j].stMedida + '</td><td class="tdStyle" width="20%"> R$' + parseFloat(response[i].childs[j].vrTotal).toFixed(2) + '</td></tr>'
                    }
                    vrTotal += parseFloat(response[i].vrDescontoFinal) - parseFloat(response[i].vrQuitadoFinal);
                    linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
                    $(linha).appendTo($("#divContaAssinada"));
                }
            } else {
                var linha = '<h4><b>Nenhuma informação para mostrar</b></h4>';
                $(linha).appendTo($("#divContaAssinada"));

            }
            $("body").removeClass("loading");
        });
    });

    $("#verDepositosConta").on("show.bs.modal", function () {
        var data = {
            action: "getDepositosConta",
            idAbertura: idAbertura
        };
        console.log('verDepositosConta.data: ', data)
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Cliente</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].stCliente + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].stFormaPagamento + '</td><td class="tdStyle">' + parseFloat(response[i].vrPagamento).toFixed(2) + '</td></tr>'
                    vrTotal += parseFloat(response[i].vrPagamento);
                }
                linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum Depósito em Conta para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divDepositosConta"));
            $("body").removeClass("loading");
        });
    });

    $("#verRepique").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        var data = {
            action: "getRepique",
            idAbertura: idAbertura
        };
        console.log('verRepique.data: ', data);
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].stCliente + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].stFormaPagamento + '</td><td class="tdStyle">' + parseFloat(response[i].vrRepique).toFixed(2) + '</td></tr>'
                    vrTotal += parseFloat(response[i].vrRepique);
                }
                linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum Repique para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divRepique"));
            $("body").removeClass("loading");
        });
    });

    $("#verCancelamento").on("show.bs.modal", function () {
        var data = {
            action: "getCancelamento",
            idAbertura: idAbertura
        };

        console.log('verCancelamento.data: ', data);
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table id="tableCancelamentos" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Operador</b></td><td class="tdStyle"><b>Produto</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Quantidade</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].stApelido + '</td><td class="tdStyle">' + response[i].stProduto + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].nrQuantidade + " " + response[i].stMedida + '</td><td class="tdStyle"> R$' + parseFloat(response[i].vrTotal).toFixed(2) + '</td></tr>'
                }
            } else {
                var linha = '<h4><b>Nenhum Cancelamento para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divCancelamento"));
            initializeDataTables("tableCancelamentos");
            $("body").removeClass("loading");
        });
    });

    $("#verTotalVendas").on("show.bs.modal", function () {
        var id = idAbertura
        var data = {
            action: "getTotalVendas",
            idAbertura: id
        };
        console.log(data);
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table id="tableTotalVendas" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Venda</b></td><td class="tdStyle"><b>Cliente</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>ValorTotal</b></td><td class="tdStyle"><b>Ação</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].idVenda + '</td><td class="tdStyle">' + response[i].idCliente + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle"> R$' + parseFloat(response[i].vrTotal).toFixed(2) + '</td><td class="tdStyle" align="center"><a onclick="verDetalheVenda(0,' + response[i].idVenda + ', 1)"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                    vrTotal += parseFloat(response[i].vrTotal);
                }
                linha += '</tbody><tfoot><tr><td class="tdStyle" colspan="3" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tfoot></table>';
            } else {
                var linha = '<h4><b>Nenhuma venda para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divTotalVendas"));
            initializeDataTables("tableTotalVendas");
            $("body").removeClass("loading");
        });
    });

    $("#verCValesRecebidos").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        var data = {
            action: "getCVale",
            idAbertura: idAbertura
        };
        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Venda</b></td><td class="tdStyle"><b>Cliente</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Valor</b></td><td class="tdStyle"><b>Valor Venda</b></td><td class="tdStyle"><center><b>Troco À Pagar</b></center></td><td class="tdStyle"><b>Valor Real Pago</b></td><td class="tdStyle"><b>Ação</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle"> ' + response[i].idVenda + ' </td><td class="tdStyle"> ' + response[i].stCliente + ' </td><td class="tdStyle"> ' + response[i].dtData + ' </td><td class="tdStyle"> ' + parseFloat(response[i].vrFormaPagamento).toFixed(2) + ' </td><td class="tdStyle">R$ ' + parseFloat(response[i].vrTotal).toFixed(2) + ' </td><td class="tdStyle">';
                    if (parseFloat(response[i].vrFormaPagamento) < parseFloat(response[i].vrTotal)) {
                        linha += 'À PAGAR:';
                    } else if (parseFloat(response[i].vrFormaPagamento) > parseFloat(response[i].vrTotal)) {
                        linha += 'TROCO:';
                    }
                    var result = (parseFloat(response[i].vrFormaPagamento) - parseFloat(response[i].vrTotal)).toFixed(2);
                    linha += ' R$ ' + result + '</td><td class="tdStyle">R$ ';
                    if (response[i].vrFormaPagamento >= response[i].vrTotal) {
                        vrTotal += parseFloat(response[i].vrTotal).toFixed(2);
                        linha += '' + parseFloat(response[i].vrTotal).toFixed(2) + '';
                    } else {
                        vrTotal += parseFloat(response[i].vrFormaPagamento).toFixed(2);
                        linha += '' + parseFloat(response[i].vrFormaPagamento).toFixed(2) + '';
                    }
                    linha += '</td><td class="tdStyle" align="center"><a onclick="verDetalheVenda(0,' + response[i].idVenda + ', 2)"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                }
                linha += '<tr><td class="tdStyle" colspan="6" align="center"><b>TOTAL</b></td><td class="tdStyle" align="right"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></td><td class="tdStyle"></td></tr></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum C-Vale para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divCValesRecebidos"));
            $("body").removeClass("loading");
        });
    });


    $("#verVouchersRecebidos").on("show.bs.modal", function () {

        // var id = $("#idAbertura").val();
        var data = {
            action: "getVoucher",
            idAbertura: idAbertura,
            flLiquidado: false
        };

        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {

                var linha = '<table class="table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF"><thead><tr><td class="tdStyle" width="9%"><b>Voucher</b></td><td class="tdStyle" width="32%"><b>Operador Autorizador</b></td><td class="tdStyle" width="25%"><b>Data</b></td><td class="tdStyle" width="25%"><b>Valor</b></td><td class="tdStyle" width="9%"><b>Ação</b></td></tr></thead><tbody';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].idVaucher.padStart(6, "0") + response[i].idAbertura.padStart(6, "0") + '</td><td class="tdStyle">' + response[i].stApelido + '</td><td class="tdStyle">' + response[i].dtEmissao + '</td><td class="tdStyle" align="right">' + 'R$ ' + parseFloat(response[i].vrVaucher).toFixed(2) + '</td><td class="tdStyle" align="center"><a onclick="verDetalheVenda(0,' + response[i].idVenda + ', 3)"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                    ;
                    vrTotal += parseFloat(response[i].vrVaucher);
                }
                linha += '<tr><td class="tdStyle" colspan="3" <b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum Voucher para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divVouchersRecebidos"));
            $("body").removeClass("loading");
        });
    });

    $("#verVouchersEmitidos").on("show.bs.modal", function () {

        var data = {
            action: "getVoucher",
            idAbertura: idAbertura,
        };

        var vrTotal = 0.00;
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table class="table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF"><thead><tr><td class="tdStyle" width="9%"><b>Voucher</b></td><td class="tdStyle" width="32%"><b>Operador Autorizador</b></td><td class="tdStyle" width="25%"><b>Data</b></td><td class="tdStyle" width="25%"><b>Valor</b></td><td class="tdStyle" width="9%"><b>Ação</b></td></tr></thead><tbody';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].idVaucher.padStart(6, "0") + response[i].idAbertura.padStart(6, "0") + '</td><td class="tdStyle">' + response[i].stApelido + '</td><td class="tdStyle">' + response[i].dtEmissao + '</td><td class="tdStyle" align="right">' + 'R$ ' + parseFloat(response[i].vrVaucher).toFixed(2) + '</td><td class="tdStyle" align="center"><a onclick="verDetalheVenda(0,' + response[i].idVenda + ', 3)"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                    ;
                    vrTotal += parseFloat(response[i].vrVaucher);
                }
                linha += '<tr><td class="tdStyle" colspan="3" <b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
            } else {
                var linha = '<h4><b>Nenhum Voucher para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divVouchersEmitidos"));
            $("body").removeClass("loading");
        });
    });


    $("#verDescontos").on("show.bs.modal", function () {
        // var id = $("#idAbertura").val();
        var data = {
            action: "getDescontos",
            idAbertura: idAbertura
        };
        $("body").addClass("loading");
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                var linha = '<table id="tabelaDescontos" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>idVenda</b></td><td class="tdStyle"><b>Autorizador</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Valor Total</b></td><td class="tdStyle"><b>Desconto</b></td><td class="tdStyle"><b>Valor Pago</b></td></tr></thead><tbody>';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].idVenda + '</td><td class="tdStyle">' + response[i].stApelido + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">R$ ' + response[i].vrTotal + '</td><td class="tdStyle"> R$' + response[i].vrDesconto + '</td><td class="tdStyle"> R$' + response[i].vrPago + '</td></tr>'
                }
            } else {
                var linha = '<h4><b>Nenhum Desconto para mostrar</b></h4>';
            }
            $(linha).appendTo($("#divDescontos"));
            initializeDataTables("tabelaDescontos");
            $("body").removeClass("loading");
        });
    });

    function listTurnos() {
        var data = {
            action: 'getTurnos'
        };
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            console.log(response)
            if (response != null) {
                var linha = '';
                for (var i = 0; i < response.length; i++) {
                    linha += '<tr><td class="tdStyle">' + response[i].stDescricao + '</td><td class="tdStyle">' + response[i].hrInicio + ' até ' + response[i].hrFim + '</td>';
                    linha += '<td class="tdStyle" style="text-align:center">';
                    linha += '<a onclick="editTurno(' + response[i].idTurno + ')"><span class="glyphicon glyphicon-edit col-md-6" title="Editar"></span></a>';
                    linha += '<a onclick="deleteTurno(' + response[i].idTurno + ')"><span class="glyphicon glyphicon-remove col-md-6" title="Excluir"></span></a>';
                    linha += '</td></tr>';
                }
                $(linha).appendTo($("#tableTurnos"));
            } else {
                var linha = '<tr><td colspan="3" align="center" class="tdStyle">Nenhum Turno cadastrado</td></tr>';
                $(linha).appendTo($("#tableTurnos"));
            }
        });
    }

    $('#modalTurnos').on('show.bs.modal', function () {
        listTurnos();
    });

    $("#caixaOnline").on("hidden.bs.modal", function () {
        $("#tableFormasPagamento").html('');
    });

    $("#verDetalhes").on("hidden.bs.modal", function () {
        openDetalhesCaixa($("#idAbertura").val());
        $("#divDetalhes").html('');
    });

    $("#verDetalheVenda").on("hidden.bs.modal", function () {
        $("#divDetalheVenda").html('');
    });

    $("#verDescontos").on("hidden.bs.modal", function () {
        $("#divDescontos").html('');
    });

    $('#modalTurnos').on('hidden.bs.modal', function () {
        $("#tableTurnos").html('');
    });

    $('#cadastroTurnos').on('hidden.bs.modal', function () {
        $("#descTurno").val('');
        $("#hrInicial").val('');
        $("#hrFinal").val('');
        $("#idTurno").val('');
        $("#modalTurnos").modal('show');
    });

    $("#verFormaPagamento").on("hidden.bs.modal", function () {
        $("#divFormaPagamento").html("");
    });

    $("#alterarFormaPagamento").on("hidden.bs.modal", function () {
        modalFormaPagamento($("#idFormaPagamentoOld").val());
        $("#idFormasPagamento").html("");
        $("#divFormaPagamento").html("");
        $("#extraInfo").html("");
    });

    $("#verSangria").on("hidden.bs.modal", function () {
        $("#divSangria").html("");
    });

    $("#verSuprimento").on("hidden.bs.modal", function () {
        $("#divSuprimento").html("");
    });

    $("#verDespesas").on("hidden.bs.modal", function () {
        $("#divDespesas").html("");
    });

    $("#verCaixaNoDia").on("hidden.bs.modal", function () {
        $("#divCaixaNoDia").html("");
    });

    $("#verContaAssinada").on("hidden.bs.modal", function () {
        $("#divContaAssinada").html("");
    });

    $("#verDepositosConta").on("hidden.bs.modal", function () {
        $("#divDepositosConta").html("");
    });

    $("#verRepique").on("hidden.bs.modal", function () {
        $("#divRepique").html("");
    });

    $("#verCancelamento").on("hidden.bs.modal", function () {
        $("#divCancelamento").html("");
    });

    $("#verTotalVendas").on("hidden.bs.modal", function () {
        $("#divTotalVendas").html("");
    });

    $("#verDetalheVenda").on("hidden.bs.modal", function () {
        $("body").addClass("loading");
        switch ($("#tipoModal").val()) {
            case "0":
                modalFormaPagamento($('#idFormaPagamento').val());
                break;
            case "1":
                openModal('verTotalVendas');
                break;
            case "2":
                openModal('verCValesRecebidos');
                break;
            case "3":
                openModal('verVouchersRecebidos');
                break;
        }

        $("#divDetalheVenda").html("");
        $("body").removeClass("loading");
    });

    $("#verCValesRecebidos").on("hidden.bs.modal", function () {
        $("#divCValesRecebidos").html("");
    });

    $("#verVouchersRecebidos").on("hidden.bs.modal", function () {
        $("#divVouchersRecebidos").html("");
    });

    $("#verVouchersEmitidos").on("hidden.bs.modal", function () {
        $("#divVouchersEmitidos").html("");
    });

    $("#calculadora").on("hidden.bs.modal", function () {
        $("#divCamposCalculadora").html("");
    });
});

function getFechamentosInit() {
    var turno = $('#selectTurnos').val();
    if (turno == null) {
        turno = 0;
    }
    var data = {
        action: "initFechamento"
    };
    var authorization = false;
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response === 1) {
            authorization = true;
        }
    });
    $('#listagem_caixas_fechados').DataTable({
        "bDeferRender": true,
        "processing": true,
        "serverSide": true,
        "bDestroy": true,
        "columns": [{
            "data": "idAbertura",
            "searchable": false
        },
            {
                "data": "dtAbertura",
                "searchable": true
            },
            {
                "data": "idCaixa",
                "searchable": true,
                "render": function (data) {
                    return 'Caixa ' + data;
                }
            },
            {
                "data": "stApelido",
                "searchable": true
            },
            {
                "data": "vrTotal",
                "searchable": false,
                "orderable": false,
                "render": function (data) {
                    return 'R$ ' + data;
                }
            },
            {
                "data": "dtAbertura",
                "searchable": true
            },
            {
                "data": "dtFechamento",
                "searchable": true
            },
            {
                "data": "idAbertura",
                "searchable": false,
                "orderable": false,
                "render": function (data) {
                    var acoes = '';
                    var botao = `<button type="button" class="btn btn-new-nati dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">`;
                    botao += '<span class="glyphicon glyphicon-cog glyphicon"></span></button>';
                    botao += '<ul class="dropdown-menu dropdown-menu-right">';
                    var endBotao = '</ul></div>';
                    if (authorization) {
                        acoes = '<center>';
                        acoes += '<div class="btn-group" role="group">';
                        acoes += '<button id="btn-search" type="button" class="btn btn-new-nati" onclick="getCaixa(' + data + ')" title="Visualizar">';
                        acoes += '<span class="glyphicon glyphicon-search glyphicon"></span>';
                        acoes += '</button>';
                        acoes += botao;
                        acoes += '<li><a href="#" onclick="fncConfirmaReabrirCaixa(' + data + ')">Re-Abrir</a></li>';
                        acoes += '<li><a href="#" onclick="fncConfirmaExclusaoCaixa(' + data + ')">Excluir</a></li>';
                        acoes += endBotao;
                        acoes += '</center>';
                    } else {
                        acoes = '<center>';
                        acoes += '<div class="btn-group" role="group">';
                        acoes += '<button type="button" class="btn btn-new-nati" onclick="getCaixa(' + data + ')" title="Visualizar">';
                        acoes += '<span class="glyphicon glyphicon-search glyphicon"></span>';
                        acoes += '</button>';
                        acoes += '<button type="button" class="btn btn-new-nati" onclick="fncConfirmaReabrirCaixa(' + data + ')" title="Re-Abrir">';
                        acoes += '<span class="glyphicon glyphicon-repeat glyphicon"></span>';
                        acoes += '</button>';
                        acoes += '</div>';
                        acoes += '</center>';
                    }
                    return acoes;
                }
            }
        ],
        "ajax": {
            url: "presidente/resources/php/serverFechamentos.php",
            data: {
                "turno": turno
            }
        },
        "language": {
            "url": "presidente/resources/js/Portuguese-Brasil.json"
        }
    });

}

function getCaixasInit() {
    data = {
        action: "initCaixa"
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            if (response.Unico) {
                var vrTotal = 0.00;
                var linha = '<div class="col-md-4 col-md-offset-4" align="center">';
                linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><thead>';
                linha += '<tr><th class="tdStyle">Data</th><th class="tdStyle">Caixa</th><th class="tdStyle">Operador</th><th class="tdStyle">Ação</th></tr>';
                linha += '</thead><tbody>';
                linha += '<tr><td colspan="4" align="center" style="padding:0px"><button type="button" class="btn btn-nati" style="width: 100%" onclick="openDetalhesCaixa(0)">Todos os Caixas</button></td></tr>';
                for (var i = 0; i < response.Unico.length; i++) {
                    vrTotal += parseFloat(response.Unico[i].vrPagamento);
                    linha += '<tr><td class="tdStyle">' + response.Unico[i].dtAbertura + '</td><td class="tdStyle">Caixa ' + response.Unico[i].idCaixa + '</td><td class="tdStyle">' + response.Unico[i].stApelido + '</td>';
                    linha += '<td class="tdStyle" style="text-align:center"><a onclick="openDetalhesCaixa(' + response.Unico[i].idAbertura + ')"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                }
                linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></td></tr></tfoot></table></div>';
            } else {
                var vrTotal = 0.00;
                var turno = response.caixas[0].descTurno;
                if (response.numTurnos == 1) {
                    divSize = '<div class="col-md-4 col-md-offset-4" align="center">';
                } else if ((response.numTurnos % 2) == 0) {
                    divSize = '<div class="col-md-4 col-md-offset-1" align="center">';
                } else {
                    divSize = '<div class="col-md-4" align="center">';
                }
                var linha = '<div class="col-md-12 form-group" align="center"><button type="button" class="btn btn-nati" onclick="openDetalhesCaixa(0)">Todos os Caixas</button></div>';
                linha += divSize;
                linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><caption class="table-caption">' + turno + '</caption><thead>';
                linha += '<tr><th class="tdStyle" width="25%">Data</th><th class="tdStyle" width="25%">Caixa</th><th class="tdStyle" width="30%">Operador</th><th class="tdStyle" width="20%">Ação</th></tr>';
                linha += '</thead><tbody>';
                for (var i = 0; i < response.caixas.length; i++) {
                    if (response.caixas[i].descTurno == turno) {
                        vrTotal += parseFloat(response.caixas[i].vrPagamento);
                        linha += '<tr><td class="tdStyle">' + response.caixas[i].dtAbertura + '</td><td class="tdStyle">Caixa ' + response.caixas[i].idCaixa + '</td><td class="tdStyle">' + response.caixas[i].stApelido + '</td>';
                        linha += '<td class="tdStyle" style="text-align:center"><a onclick="openDetalhesCaixa(' + response.caixas[i].idAbertura + ')"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                    } else {
                        turno = response.caixas[i].descTurno;
                        linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2);
                        +'</b></td></tr></tfoot>';
                        vrTotal = 0.00;
                        linha += '</table></div>';
                        linha += divSize;
                        linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><caption class="table-caption">' + turno + '</caption><thead>';
                        linha += '<tr><th class="tdStyle" width="25%">Data</th><th class="tdStyle" width="25%">Caixa</th><th class="tdStyle" width="30%">Operador</th><th class="tdStyle" width="20%">Ação</th></tr>';
                        linha += '</thead><tbody>';
                        i--;
                    }
                }
                linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></td></tr></tfoot>';
                linha += '</table></div>';
            }
        } else {
            var linha = '<div class="col-md-12" align="center"><h3>Nenhum caixa está aberto no momento!</h3></div><br>';
        }
        $(linha).appendTo($("#divCaixasOnline"));
    });
}

function openDetalhesCaixa(idAbertura) {

    $("#idAbertura").val(idAbertura)

    $("body").addClass("loading");
    let data = {};
    if (idAbertura === 0) {
        data = {
            action: 'getDadosTodosCaixas'
        };
    } else {
        data = {
            action: 'getDadosCaixa',
            idAbertura: idAbertura
        };
    }
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        console.log(idAbertura)
        $("body").removeClass("loading");
        $("#horarioAtual").html('Horário: ' + response.horaAtual);
        $("#iniciadoEm").html('Iniciado em: ' + response.iniciadoEm);
        $("#stOperador").html('Operador: ' + response.stNome);
        $("#vrInicial").html('Valor inicial: R$ ' + response.valorInicial);
        $("#vrSangria").html('<a onclick="verDetalhesSangria(' + idAbertura + ')">Sangrias:</a> R$ ' + response.vrSangria);
        $("#nrClientes").html('Numero de clientes: ' + response.nrClientes);
        $("#nrVendas").html('<a onclick="verDetalhesVendas(' + idAbertura + ')">Total de vendas:</a> ' + response.totalClientes);
        $("#vrDespesas").html('<a onclick="verDetalhesDespesas(' + idAbertura + ')">Despesas:</a> R$ ' + response.outrasDesp);
        $("#vrIndustria").html('<a onclick="verDetalhesIndustria(' + idAbertura + ')">Indústria:</a> R$ ' + response.industria);
        $("#vrContaAssinada").html('<a onclick="verDetalhesContaAssinada(' + idAbertura + ')">Vendas em Conta Assinada:</a> R$ ' + response.contas);
        $("#vrDeposContas").html('<a onclick="verDetalhesDepositos(' + idAbertura + ')">Depos. contas:</a> R$ ' + response.depContas);
        $("#vrCValeEmitido").html('C-vales emitidos: R$ ' + response.cValesEmitidos);
        $("#vrCValeRecebido").html('C-vales recebidos: R$ ' + response.cValesRecebidos);
        $("#vrCValeDGEmitido").html('C-vales DG emitidos: R$ ' + response.cValesEmitidosDG);
        $("#vrCValeDGRecebido").html('C-vales DG recebidos: R$ ' + response.cValesRecebidosDG);
        $("#nrCancelmento").html('<a onclick="verDetalhesCancelamento(' + idAbertura + ')">Cancelamentos:</a> ' + response.itensExcluidos);
        $("#vrDesconto").html('Descontos: R$ ' + response.vrDesconto);
        $("#vrEstornoDepConta").html('Estorno depos. contas: R$ ' + response.estornoDepContas);
        $("#vrSuprimento").html('<a onclick="verDetalhesSuprimento(' + idAbertura + ')">Suprimento:</a> R$ ' + response.vrSuprimento);
        $("#vrAcrescimo").html('Acrescimo: R$ ' + response.vrAcrescimo);
        $("#vrRepique").html('<a onclick="verDetalhesRepique(' + idAbertura + ')">Repique:</a> R$ ' + response.vrRepique);
        $("#nrNFP").html("Número de NFP's: " + response.nrVendasNFP);
        $("#porcNFP").html("Porcentagem de NFP's: " + response.vrNFP + " (" + response.porcentagemNFP + "%)");
        var linha = '';
        if (response.formasPagamento) {
            if (response.depContas) {
                linha += '<tr><td class="tdStyle" width="50%">DEP. CONTAS</td>';
                linha += '<td class="tdStyle" width="50%">R$ ' + response.depContas + '</td></tr>';
            }
            for (var i = 0; i < response.formasPagamento.length; i++) {
                linha += '<tr><td class="tdStyle" width="50%">' + response.formasPagamento[i].stFormaPagamento + '</td>';
                linha += '<td class="tdStyle" width="50%">R$ ' + response.formasPagamento[i].vrPagamento + '</td></tr>';
            }
        }
        linha += '<tr><td class="tdStyle" width="50%"><b>RECEITA:</b></td><td class="tdStyle" width="50%"><b>R$ ' + response.vrTotalPagamento + '</b></td></tr>';
        $(linha).appendTo($("#tableFormasPagamento"));
        if (idAbertura == 0) {
            $("#caixaOnlineLabel").html('Posição On-Line de TODOS os Caixas');
        } else {
            $("#caixaOnlineLabel").html('Posição On-Line do Caixa ' + response.idCaixa);
        }
        $("#caixaOnline").modal('show');
    });
}

function verDetalhesSangria(idAbertura) {
    var data = {
        action: 'getSangria',
        idAbertura: idAbertura
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                vrTotal += parseFloat(response[i].vrSangria);
                linha += '<tr><td style="tdStyle">' + response[i].stApelido + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrSangria).toFixed(2) + '</td></tr>';
            }
            linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
        } else {
            var linha = '<h4><b>Nenhuma Sangria para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Sangria');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesVendas(idAbertura) {
    var data = {
        action: 'getTotalVendas',
        idAbertura: idAbertura
    };
    var vrTotal = 0.00;
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        console.log('detalhe: ', response)
        if (response) {
            var linha = '<table id="tableDetalhesVendas" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Venda</b></td><td class="tdStyle"><b>Cliente</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>ValorTotal</b></td><td class="tdStyle"><b>Ação</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr id="vendasAbertas' + response[i].idAbertura + '-' + response[i].idVenda + '"><td class="tdStyle">' + response[i].idVenda + '</td>';
                linha += '<td class="tdStyle">' + response[i].idCliente + '</td>';
                linha += '<td class="tdStyle">' + response[i].dtData + '</td>';
                linha += '<td class="tdStyle"> R$' + parseFloat(response[i].vrTotal).toFixed(2) + '</td>';
                linha += '<td class="tdStyle" align="center">';
                linha += '<a onclick="verVendaAberta(' + response[i].idAbertura + ',' + response[i].idVenda + ')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-search col-md-6" align="center" data-toogle="tooltip" title="Visualizar"></span></a>';
                linha += '<a onclick="excluirVendaAberta(' + response[i].idAbertura + ',' + response[i].idVenda + ')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" data-toogle="tooltip" title="Cancelar"></span></a>';
                linha += '</td></tr>';
                vrTotal += parseFloat(response[i].vrTotal);
            }
            linha += '</tbody><tfoot><tr><td class="tdStyle" colspan="3" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tfoot></table>';
        } else {
            var linha = '<h4><b>Nenhuma venda para mostrar</b></h4>';
        }
        $("#caixaOnline").modal('hide');
        $("#verDetalhesTitulo").html('Detalhes Vendas');
        $(linha).appendTo($("#divDetalhes"));
        initializeDataTables("tableDetalhesVendas");
        $("#verDetalhes").modal('show');
    });
}

function verVendaAberta(idAbertura, idVenda) {
    var vrTotal = 0.00;
    $("#idAberturaVenda").val(idAbertura);
    var data = {
        action: 'getDetalheVenda',
        idAbertura: idAbertura,
        idVenda: idVenda
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        if (dados) {
            $("#verDetalheVendaTitulo").html("Itens da venda " + idVenda);
            var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Operador</b></td><td class="tdStyle"><b>Código</b></td><td class="tdStyle"><b>Produto</b></td><td class="tdStyle"><b>Quantidade</b></td><td class="tdStyle"><b>Total</b></td></tr></thead><tbody>';
            for (var i = 0; i < dados.length; i++) {
                linha += '<tr><td class="tdStyle">' + dados[i].stAtendente + '</td><td class="tdStyle">' + dados[i].idCodProduto + '</td><td class="tdStyle">' + dados[i].stProduto + '</td><td class="tdStyle">' + dados[i].nrQuantidade + " " + dados[i].stMedida + '</td><td class="tdStyle">' + parseFloat(dados[i].vrTotal).toFixed(2) + '</td></tr>';
                vrTotal += parseFloat(dados[i].vrTotal);
            }

            linha += '<tr><td class="tdStyle" colspan="3" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
        } else {
            var linha = '<h4><b>Nenhum detalhe para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalheVenda"));
        $("#verDetalheVenda").modal('show');
        $("body").removeClass("loading");
    });
}

function excluirVendaAberta(idAbertura, idVenda) {
    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    swal({
        title: 'Cancelar venda',
        text: 'Tem certeza que deseja cancelar esta venda?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function () {
        var data = {
            action: 'excluirVenda',
            idAbertura: idAbertura,
            idVenda: idVenda
        };
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                toastr.success(response.msg);
                $("#vendasAbertas" + idAbertura + '-' + idVenda).remove();
            } else {
                toastr.error(response.msg);
            }
        });
    });
}

function verDetalhesDespesas(idAbertura) {
    var vrTotal = 0.00;
    var data = {
        action: 'getDespesas',
        idAbertura: idAbertura
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Despesa</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Forma</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                vrTotal += parseFloat(response[i].vrDespesa);
                linha += '<tr><td style="tdStyle">' + response[i].stDescricao + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrDespesa).toFixed(2) + '</td></tr>'
            }
            linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
        } else {
            var linha = '<h4><b>Nenhuma Despesa para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Despesas');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesContaAssinada(idAbertura) {
    var vrTotal = 0.00;
    var vrGrandTotal = 0;
    var flQuit = true;
    var flDesc = true;
    var flCliente = true;
    var data = {
        action: 'getContaAssinada',
        idAbertura: idAbertura
    };
    console.log(idAbertura);
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        var linha = '';
        linha += '<div style="max-height: 600px; overflow-y: scroll;">';
        if (response) {
            for (var i = 0; i < response.length; i++) {
                console.log('response.length =>', response[i]);
                vrTotal = 0;

                linha += '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse">';
                linha += '<thead><tr><td class="tdStyle" colspan="2" width="80%"><b>' + response[i].stCliente + ' </b></td><td class="tdStyle" width="20%"><b>' + response[i].dtData + ' </b></td></tr></thead><tbody>';
                // if (response[i].childs !) {
                for (var j = 0; j < response[i].childs.length; j++) {
                    console.log('chield =>', response[i].childs[j]);
                    // if (flCliente) {
                    if (response[i].childs[j].vrQuitado > "0.00" && flQuit) {
                        linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR QUITADO</b></td><td class="tdStyle" width="20%"><b>' + parseFloat(response[i].childs[j].vrQuitado).toFixed(2) + ' </b></td></tr>';
                        flQuit = false;
                    }
                    if (response[i].childs[j].vrDesconto !== "0.00" && flDesc) {
                        linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>DESCONTO</b></td><td class="tdStyle" width="20%"><b>' + parseFloat(response[i].childs[j].vrDesconto).toFixed(2) + ' </b></td></tr>'
                        flDesc = false;
                    }
                    flCliente = false;
                    // }
                    // vrTotal += parseFloat(response[i].childs[j].vrTotal);
                    // console.log(response[i].childs[j].stProduto)
                    linha += '<tr><td class="tdStyle" width="60%">' + response[i].childs[j].stProduto + '</td><td class="tdStyle" width="20%">' + response[i].childs[j].nrQuantidade + " " + response[i].childs[j].stMedida + '</td><td class="tdStyle" width="20%"> R$' + parseFloat(response[i].childs[j].vrTotal).toFixed(2) + '</td></tr>';

                    // }
                }
                // vrTotal += parseFloat(response[i].vrDescontoFinal) - parseFloat(response[i].vrQuitadoFinal);
                vrGrandTotal += parseFloat(response[i].vrTotal);

                linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(response[i].vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
            }

        } else {
            linha = '<h4><b>Nenhuma Venda em Conta Assinada para mostrar</b></h4>';
        }

        // linha += '</div><br /> <br />';
        // linha += '<h4><b>VALOR TOTAL:</b></h4>';
        // linha += '<span class="text-right"><b>R$' +parseFloat(vrGrandTotal).toFixed(2)+'</b></span>';
        linha += '<table>' +
            '<tfoot>' +
            '<tr>' +
            '<td colspan="9" width="100%" rowspan="1" colspan="6"><b>VALOR TOTAL:</b></td>' +
            '<td></td><td></td><td class="tdStyle" width="20%" colspan="3" rowspan="1"><h3>R$' + parseFloat(vrGrandTotal).toFixed(2) + ' </h3></td></tr></tfoot></table>'

        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Conta Assinada');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesDepositos(idAbertura) {
    var data = {
        action: 'getDepositosConta',
        idAbertura: idAbertura
    };

    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        var linha = '';
        if (response) {
            var vrTotal = 0;
            linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Cliente</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr><td class="tdStyle">' + response[i].stCliente + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].stFormaPagamento + '</td><td class="tdStyle">' + parseFloat(response[i].vrPagamento).toFixed(2) + '</td></tr>'
                vrTotal += parseFloat(response[i].vrPagamento);
            }
            linha += '<tr><td class="tdStyle" colspan="3" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
        } else {
            linha = '<h4><b>Nenhum Depósito em Conta para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Depositos em Conta');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesCancelamento(idAbertura) {
    var data = {
        action: 'getCancelamento',
        idAbertura: idAbertura
    };

    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            var linha = '<table id="tableDetalhesCancelamentos" class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Operador</b></td><td class="tdStyle"><b>Produto</b></td><td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>Quantidade</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr><td class="tdStyle">' + response[i].stApelido + '</td><td class="tdStyle">' + response[i].stProduto + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].nrQuantidade + " " + response[i].stMedida + '</td><td class="tdStyle"> R$' + parseFloat(response[i].vrTotal).toFixed(2) + '</td></tr>'
            }
        } else {
            var linha = '<h4><b>Nenhum Cancelamento para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Cancelamentos');
        initializeDataTables("tableDetalhesCancelamentos");
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesSuprimento(idAbertura) {
    var data = {
        action: 'getSuprimento',
        idAbertura: idAbertura
    };
    console.log(data);
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                vrTotal += parseFloat(response[i].vrSangria);
                linha += '<tr><td style="tdStyle">' + response[i].stApelido + '</td><td style="tdStyle">' + response[i].dtData + '</td><td style="tdStyle">' + response[i].stFormaPagamento + '</td><td style="tdStyle" align="right">R$' + parseFloat(response[i].vrSangria).toFixed(2) + '</td></tr>';
            }
            linha += '<tr><td class="tdStyle" colspan="3"><b>VALOR TOTAL::</b></td><td class="tdStyle" align="right"><b>R$' + parseFloat(vrTotal).toFixed(2) + '</b></td></tbody></table>';
        } else {
            var linha = '<h4><b>Nenhum Suprimento para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Suprimentos');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function verDetalhesRepique(idAbertura) {
    var data = {
        action: 'getRepique',
        idAbertura: idAbertura
    };
    $("#idAbertura").val(idAbertura);
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            var linha = '<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Por</b></td><td class="tdStyle"><b>Em</b></td><td class="tdStyle"><b>Tipo</b></td><td class="tdStyle"><b>Valor</b></td></tr></thead><tbody>';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr><td class="tdStyle">' + response[i].stCliente + '</td><td class="tdStyle">' + response[i].dtData + '</td><td class="tdStyle">' + response[i].stFormaPagamento + '</td><td class="tdStyle">' + parseFloat(response[i].vrRepique).toFixed(2) + '</td></tr>'
                vrTotal += parseFloat(response[i].vrRepique);
            }
            linha += '<tr><td class="tdStyle" colspan="2" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
        } else {
            var linha = '<h4><b>Nenhum Repique para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divDetalhes"));
        $("#verDetalhesTitulo").html('Detalhes Repique');
        $("#caixaOnline").modal('hide');
        $("#verDetalhes").modal('show');
    });
}

function setMoneyFormat(input, evento, total) {
    if (input.value.length < 10 || evento.keyCode == 8 || evento.keyCode == 46 || evento.keyCode == 9 || evento.keyCode == 43 || evento.keyCode == 45 || evento.keyCode == 107 || evento.keyCode == 109) {
        if ((evento.keyCode >= 48 && evento.keyCode <= 57) || (evento.keyCode >= 96 && evento.keyCode <= 105) || evento.keyCode == 8 || evento.keyCode == 46 || evento.keyCode == 43 || evento.keyCode == 45 || evento.keyCode == 107 || evento.keyCode == 109) {
            var result = "";

            switch (evento.keyCode) {
                case evento.keyCode = 45:
                case evento.keyCode = 109:
                    if (input.value.substring(0, 1) != '-') {
                        result = "-" + input.value;
                        break;
                    } else {
                        evento.returnValue = false;
                        return false;
                    }
                case evento.keyCode = 43:
                case evento.keyCode = 107:
                    if (input.value.substring(0, 1) == '-') {
                        result = input.value.substring(1, input.value.length);
                        break;
                    } else {
                        evento.returnValue = false;
                        return false;
                    }
                case evento.keyCode = 8:
                case evento.keyCode = 46:
                    result = input.value.substring(0, (input.value.length - 1));
                    break;
                case evento.keyCode = 48:
                case evento.keyCode = 96:
                    result = input.value + "0";
                    break;
                case evento.keyCode = 49:
                case evento.keyCode = 97:
                    result = input.value + "1";
                    break;
                case evento.keyCode = 50:
                case evento.keyCode = 98:
                    result = input.value + "2";
                    break;
                case evento.keyCode = 51:
                case evento.keyCode = 99:
                    result = input.value + "3";
                    break;
                case evento.keyCode = 52:
                case evento.keyCode = 100:
                    result = input.value + "4";
                    break;
                case evento.keyCode = 53:
                case evento.keyCode = 101:
                    result = input.value + "5";
                    break;
                case evento.keyCode = 54:
                case evento.keyCode = 102:
                    result = input.value + "6";
                    break;
                case evento.keyCode = 55:
                case evento.keyCode = 103:
                    result = input.value + "7";
                    break;
                case evento.keyCode = 56:
                case evento.keyCode = 104:
                    result = input.value + "8";
                    break;
                case evento.keyCode = 57:
                case evento.keyCode = 105:
                    result = input.value + "9";
                    break;
            }

            result = result.replace(".", "");

            while (result.substring(0, 1) == "0") {
                result = result.substring(1, result.length);
            }

            if (result.length > 0) {
                if (result.length == 1) {
                    var end = result;

                    var r = "0.0" + end;
                } else if (result.length == 2) {
                    var end = result;

                    var r = "0." + end;
                } else if (result.length >= 3) {
                    var ini = result.substring(0, (result.length - 2));
                    var end = result.substring(result.length - 2);

                    var r = ini + "." + end;
                }

                result = r;
                input.value = result;
            } else {
                input.value = "0.00";
            }
        } else if (evento.keyCode == 9)
            return evento.keyCode;

        try {
            somarValores(input.name, total);
        } catch (ex) {
        }
    }
    evento.returnValue = false;
    return false;
}

function initializeDataTables(name) {
    if (!$.fn.DataTable.isDataTable('#' + name)) {
        $('#' + name).DataTable({
            "language": {
                "url": "presidente/resources/js/Portuguese-Brasil.json"
            }
        });
    }
}

function openModal(target) {
    switch (target) {
        case 'verSangria':
            $('#verSangria').modal('show');
            break;
        case 'verSuprimento':
            $("#verSuprimento").modal('show');
            break;
        case 'verDespesas':
            $("#verDespesas").modal('show');
            break;
        case 'verContaAssinada':
            $("#verContaAssinada").modal('show');
            break;
        case 'verDepositosConta':
            $("#verDepositosConta").modal('show');
            break;
        case 'verRepique':
            $("#verRepique").modal('show');
            break;
        case 'verCancelamento':
            $("#verCancelamento").modal('show');
            break;
        case 'verTotalVendas':
            $("#verTotalVendas").modal('show');
            break;
        case 'verCValesRecebidos':
            $("#verCValesRecebidos").modal('show');
            break;
        case 'verVouchersRecebidos':
            $("#verVouchersRecebidos").modal('show');
            break;
        case 'verVouchersEmitidos':
            $("#verVouchersEmitidos").modal('show');
            break;
        case verCaixaNoDia:
            $("#verCaixaNoDia").modal('show');
            break;
        case 'verDescontos':
            $('#verDescontos').modal('show');
            break;
    }
};


function fncConfirmaFechamentoCaixa() {
    $('#btnFecharCaixa').attr('disabled', true);
    toastr.options = {
        "positionClass": "toast-bottom-right"
    }

    swal({
        title: 'Fechamento de caixa',
        text: 'Tem certeza que deseja fechar este caixa?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function (action) {
        if (action) {
            $("body").addClass("loading");
            vrTrocoEncerramento = $("#vrEncerramento").val();
            vrFechamento = $("#totalReceita").val();
            stOBS = $("#txtObs").val();
            chkAbrirRelatorio = $("#chkAbrirRelatorio").is(':checked');
            vrApurado = $("#somaReceita").val();
            vrDiferenca = $("#diferencaReceita").val();
            var inputsD = $("input[name*='vrD']");
            var inputsN = $("input[name*='vrN']");
            var inputsX = $("input[name*='vrX']");
            var detalhesPagamento = [];
            console.log('idAbertura: ', idAbertura, '\nvrFechamento: ', vrFechamento, '\nvrApurado: ', vrApurado, '\nvrDiferença: ', vrDiferenca);

            for (var i = 0; i < inputsN.length; i++) {
                idFormaPagamento = inputsN[i].name.replace(/\D/g, '');
                nAtual = inputsN[i].value;
                xAtual = inputsX[i].value;
                dAtual = inputsD[i].value;

                var obj;

                if (idFormaPagamento === 1) {
                    atual = parseFloat(parseFloat(nAtual) + vrDespesaF + vrSangriaF).toFixed(2);
                    obj = {
                        idFormaPagamento: idFormaPagamento,
                        nAtual: atual,
                        xAtual: xAtual,
                        dAtual: dAtual
                    }
                } else {
                    obj = {
                        idOperador: idOperador,
                        idFormaPagamento: idFormaPagamento,
                        nAtual: nAtual,
                        xAtual: xAtual,
                        dAtual: dAtual
                    };
                }

                detalhesPagamento.push(obj);
            }
            var data = {
                action: 'salvarFechamento',
                idOperador: idOperador,
                vrTrocoEncerramento: vrTrocoEncerramento,
                idAbertura: idAbertura,
                vrFechamento: vrFechamento,
                observacao: stOBS,
                chkAbrirRelatorio: chkAbrirRelatorio,
                vrApurado: vrApurado,
                vrDiferenca: vrDiferenca,
                detalhesPagamento: detalhesPagamento,
                historico: {
                    vrApurado: vrApurado,
                    vrFechamento: vrFechamento,
                    vrDiferenca: vrDiferenca
                }
            };
            console.log(detalhesPagamento);
            axios.post(`/api/v1/gerenciador/${idAbertura}/close`, data)
                .then(res => {
                    console.log('res => ', res);
                    toastr.success("Caixa fechado com sucesso");
                    setTimeout(function () {
                        document.location = '?sec=presidente&sub=fechamento'
                    }, 1000);
                })
                .catch(err => {
                    console.log('err =>', err)
                    toastr.error(err.msg);
                })
                .finally(() => {
                    $('#btnFecharCaixa').removeAttr('disabled');
                    $("body").removeClass("loading")
                });
            // $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            //     $("body").removeClass("loading");
            //     if (response.status) {
            //         toastr.success(response.msg);
            //         setTimeout(function () {
            //             document.location = response.location
            //         }, response.time);
            //     } else {
            //         toastr.error(response.msg);
            //     }
            // });
        } else {
            $('#btnFecharCaixa').removeAttr('disabled');
        }
    });
}

function fncImpressao() {
    var divToPrint = document.getElementById('detalheFexamentoCaixa');
    newWin = window.open("");
    newWin.document.write('<style> .oculta{ display: none; }</style>');
    newWin.document.write(divToPrint.outerHTML);
    newWin.document.write('<html><body><table><tr><td></td></tr><tr><td>Valor de Abertura: ' + vrAbertura.value + '</tr>');
    newWin.document.write('<tr><td></td></tr>');
    newWin.document.write('<tr></tr><tr><td width="36%">FORMA DE PAGAMENTO </td><td width="18%"> OPERADOR </td><td width="18%"> SISTEMA </td><td width="18%"> DIFERENÇA</td></tr>');
    var inputsD = $("input[name*='vrD']");
    var inputsN = $("input[name*='vrN']");
    var inputsX = $("input[name*='vrX']");
    var detalhesPagamento = [];
    for (var i = 0; i < inputsN.length; i++) {
        idFormaPagamento = inputsN[i].name.replace(/\D/g, '');
        nAtual = inputsN[i].value;
        xAtual = inputsX[i].value;
        dAtual = inputsD[i].value;
        newWin.document.write('<tr><td>' + $('#lbl' + idFormaPagamento).html() + '</td><td>' + nAtual + '</td><td>' + xAtual + '</td><td>' + dAtual + '</td></tr>');
    }
    newWin.document.write('<tr><td width="36%">RECEITA:</td><td width="18%">' + somaReceita.value + '</td><td width="18%">' + totalReceita.value + '</td><td width="18%">' + diferencaReceita.value + '</td></tr>');
    // newWin.document.write('<tr><td width="36%">RETENÇÃO:</td><td width="18%"></td><td width="18%">' + totalAdq.value + '</td><td width="18%"></td></tr><tr><td></td></tr>');
    newWin.document.write('<table><tr><td width="30%">OBSERVAÇÃO:</td><td width="70%">' + txtObs.value + '</td></tr></table>');
    newWin.document.write('</table></body></html>');
    newWin.print();
    newWin.close();
}

function fncConfirmaExclusaoCaixa(id) {
    toastr.options = {
        "positionClass": "toast-bottom-right"
    }

    swal({
        title: 'Exclusão de caixa',
        text: 'Tem certeza que deseja excluir este caixa? Esta ação não pode ser revertida',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function () {
        $("body").addClass("loading");
        var data = {
            action: "deleteAbertura",
            idAbertura: id
        };
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    document.location = response.location
                }, response.time);
            } else {
                toastr.error(response.msg);
            }
        });
        return true;
    });
}

function fncConfirmaReabrirCaixa(id) {
    toastr.options = {
        "positionClass": "toast-bottom-right"
    }

    swal({
        title: 'Re-abrir de caixa',
        text: 'Tem certeza que deseja re-abrir este caixa?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function () {
        $("body").addClass("loading");
        var data = {
            action: "reabrirCaixa",
            idAbertura: id
        };
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    document.location = response.location
                }, response.time);
            } else {
                toastr.error(response.msg);
            }
        });
        return true;
    });
}

function getCaixa(id) {
    console.log('getCaixa =>', id);
    $('#registroCaixa').attr("hidden", false);
    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    $("body").addClass("loading");

    var data = {
        action: "getCaixa",
        idAbertura: id
    };

    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        console.log('getcaixa:', dados);
        console.log('abertura:', dados.vrDepContas);
        if (dados.status) {
            toastr.error(dados.msg);
            $("body").removeClass("loading");
        } else {

            idAbertura = id;
            $('#idAbertura').val(data.idAbertura);
            $("#tituloRegistroCaixa").html("Registro de Fechamento do Caixa " + dados.idCaixa);
            $("#idAbertura").val(dados.idAbertura);
            $("#idCaixa").val(dados.idCaixa);
            $("#idOperador").val(dados.idOperador);
            $("#operador").html(dados.stApelido);
            $("#horaAbertura").html(dados.dtAbertura);
            $("#horaFechamento").html(dados.dtFechamento);
            $("#sangria").html("R$ " + dados.vrSangria);
            $("#suprimento").html("R$ " + dados.vrSuprimento);
            $("#despesa").html("R$ " + dados.vrDespesa);
            $("#vendaContaAssinada").html("R$ " + dados.vrContaAssinada);
            $("#depositoConta").html("R$ " + dados.vrDepContas);
            $("#estornoDespConta").html("R$ " + dados.vrEstorno);
            $("#cValesEmitidos").html("R$ " + dados.vrCValesEmitidos);
            $("#cValesRecebidos").html("R$ " + dados.cValesRecebidos);
            $("#vouchers").html("R$ " + dados.vouchers);
            $("#vouchersEmitidos").html("R$ " + dados.vouchersEmitidos);
            $("#valeDGEmitido").html("R$ " + dados.cValesEmitidosDG);
            $("#valeDGRecebido").html("R$ " + dados.cValesRecebidosDG);
            $("#taxaServico").html("R$ " + parseFloat(dados.vrAcrescimo).toFixed(2));
            $("#taxaEntrega").html("R$ " + parseFloat(dados.vrTaxaEntrega).toFixed(2));
            $("#repique").html("R$ " + dados.vrRepique);
            $("#totalVendas").html(dados.totalVendas);
            $("#numClientes").html(dados.nrClientes);
            $("#cancelamentos").html(dados.itensExcluidos);
            $("#vrAbertura").val(parseFloat(dados.vrAbertura).toFixed(2));
            vrSangriaF = parseFloat(dados.vrSangria);
            vrDespesaF = parseFloat(dados.vrDespesa);
            depContaF = dados.vrDepContas;
            vrAberturaF = parseFloat(dados.vrAbertura).toFixed(2);
            if (dados.vrDesconto) {
                $("#descontos").html("R$ " + parseFloat(dados.vrDesconto).toFixed(2));
            } else {
                $("#descontos").html("R$ 0.00");
            }
            $("#taxaServico").html("R$ " + parseFloat(dados.vrAcrescimo).toFixed(2));
            $("#taxaEntrega").html("R$ " + parseFloat(dados.vrTaxaEntrega).toFixed(2));
            $("#repique").html("R$ " + dados.vrRepique);
            $("#totalVendas").html(dados.totalVendas);
            $("#numClientes").html(dados.nrClientes);
            $("#cancelamentos").html(dados.itensExcluidos);
            $("#vrAbertura").val(parseFloat(dados.vrAbertura).toFixed(2));
            $("#vrEncerramento").val(parseFloat(dados.vrAbertura).toFixed(2));

            getValoresVendaCaixa(id);
        }
        //Vezes que o caixa foi fechado naquele dia por aquele operador
        //     var data = {action: "getVezesFechamentoCaixa", idOperador: dados.idOperador, idCaixa: dados.idCaixa, dtAbertura: dados.dtAbertura};
        //     $.post('presidente/resources/php/presidente_functions.php', data, function(response) {

        //         $("#caixaNoDia").html('<a onclick="openModal(' + 'verCaixaNoDia' + ')">' + response.msg + '</a>');
        //         $("#registroCaixa").removeAttr('hidden');
        //     });
        // }
        $("body").removeClass("loading");
    });
}

function getDepositoEmDinheiro(idAbertura) {
    // buscar depositos
    var data = {
        action: "getDepositosDinheiro",
        idAbertura: idAbertura
    };

    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        if (dados) {
            depContaDinheiro = parseFloat(dados.valor);

            console.log('depContaDinheiro =>', depContaDinheiro)
        }
    });
}

function getValoresVendaCaixa(idAbertura) {
    console.log('getValoresVendaCaixa(' + idAbertura + ')');

    getDepositoEmDinheiro(idAbertura);

    depContaDinheiro = 0;
    var data = {
        action: "getVendasCaixa",
        idAbertura: idAbertura
    };
    $("#tbodyFormasPagamento").html("");
    $("body").addClass("loading");
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        $("body").removeClass("loading");
        if (dados) {
            console.log(dados);

            let linha = '';
            let addAbertura = $("#vrAbertura").val();
            var vrAF = parseFloat(vrAberturaF);
            var vrSF = parseFloat(vrSangriaF);
            var vrCF = parseFloat(depContaDinheiro);
            var vrTotalReceita = vrCF;
            var din = false;
            for (var i in dados) {
                if (din == false) {
                    console.log('din', din);

                    if ((dados[i].idFormaPagamento == 1 && dados[i].idTipo == 1) || (dados[i].idTipo == 1 && dados[i].stFormaPagamento.toUpperCase().trim() == "DINHEIRO")) {
                        din = true;
                        var vrTotalAdq = 0;
                        vrTotalReceita += parseFloat(dados[i].vrPagamento);
                        var vrPF = parseFloat(dados[i].vrPagamento);
                        var vrTF = parseFloat(vrCF + vrPF).toFixed(2);
                        var dif = vrTF - vrSF - vrCF - vrDespesaF;
                        idDinheiro = dados[i].idFormaPagamento;
                        linha = `
                    <tr class="trDinheiro">
                        <td style="vertical-align: middle; font-size: 14px; font-weight: bold;" class="tdDinheiro">
                            <a id="btn-dinheiro">
                                <span id="icon"><i class="glyphicon glyphicon-plus"></i></span>
                                <label class="tdStyle" id="lbl+${dados[i].idFormaPagamento}">
                                    <a onclick="modalFormaPagamento(${dados[i].idFormaPagamento}, ${idAbertura})">${dados[i].stFormaPagamento}</a>
                               </label>
                            </a>
                        </td>
                        <td class="inputDinamico">
                            <input type="text" style="text-align:right" name="${'vrN' + dados[i].idFormaPagamento}" id="${'n' + dados[i].idFormaPagamento}" data-tipo="parent" class="form-control" onkeydown="return setMoneyFormat(this, event, false)" onkeyup="setValores(this.id)" value="0.00"/>
                        </td>
                        <td class="inputDinamico">
                            <input type="text" style="text-align:right;" name="${'vrX' + dados[i].idFormaPagamento}" id="${'x' + dados[i].idFormaPagamento}" class="form-control" value="${vrTF}" readonly/>
                        </td>
                        <td class="inputDinamico">
                            <input type="text" style="text-align:right;" name="${'vrD' + dados[i].idFormaPagamento}" id="${'d' + dados[i].idFormaPagamento}" class="form-control" value="${parseFloat(0.00 - dif).toFixed(2)}" readonly/>
                        </td>
                        <td class="inputDinamico" style="vertical-align: middle" class="oculta">
                            <input type="button" class="bcalculator" onclick="abrirCalculadora(${dados[i].idFormaPagamento})"/>
                        </td>
                    </tr>
                    <tr class="collapseDinheiro collapse" bgcolor="#fafafa">
                        <td style="vertical-align:middle;">
                            <label class="tdStyle">          Valor de Abertura</label>
                        </td>
                        <td style="text-align:right;">
                            <b><label class="tdStyle">( + )</label></b>
                        </td>
                        <td style="text-align:right;">
                            <b><label class="tdStyle">${vrAberturaF}</label></b>
                        </td>
                        <td>
                            <label class="checkbox-inline tdStyle" style="cursor:pointer; text-align: center;">
                                <b><input type="checkbox" id="chkSomaAbertura" onchange="somarAbertura()" style="cursor:pointer"/>Somar Abertura</b>
                            </label>
                        </td>
                        <td></td>
                    </tr>
                    <tr class="collapseDinheiro collapse" bgcolor="#fafafa">
                        <td style="vertical-align:middle;"><label class="tdStyle">          Depósitos em Conta</label></td>
                        <td style="text-align:right;"><b><label class="tdStyle">( + )</label></b></td>
                        <td style="text-align:right;"><b><label class="tdStyle">${parseFloat(depContaDinheiro).toFixed(2)}</label></b></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr class="collapseDinheiro collapse" bgcolor="#fafafa">
                        <td style="vertical-align:middle;"><a onclick="modalFormaPagamento(${dados[i].idFormaPagamento}, ${idAbertura})"><label class="tdStyle">          Vendas</label></a></td>
                        <td style="text-align:right;"><b><label class="tdStyle">( + )</label></b></td>
                        <td style="text-align:right;"><b><label class="tdStyle">${dados[i].vrPagamento}</label></b></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr class="collapseDinheiro collapse" bgcolor="#fafafa">
                        <td style="vertical-align:middle;"><label class="tdStyle">          Sangrias</label></td>
                        <td style="text-align:right;"><b><label" class="tdStyle">+ ${parseFloat(vrSangriaF).toFixed(2)}</label></b></td>
                        <td style="text-align:right;"><b><label style="color: red;" class="tdStyle"></label></b></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr class="collapseDinheiro collapse" bgcolor="#fafafa">
                        <td style="vertical-align:middle;"><label class="tdStyle">          Despesas</label></td>
                        <td style="text-align:right;"><b><label class="tdStyle">+ ${parseFloat(vrDespesaF).toFixed(2)}</label></b></td>
                        <td style="text-align:right;"><b><label style="color: red;" class="tdStyle"></label></b></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr class="collapseDinheiro collapse dinamico">
                        <td style="vertical-align:middle;"><label class="tdStyle">          Total</label></td>
                    </tr>`;
                        $(linha).appendTo($("#tbodyFormasPagamento"));

                    }
                }
            }
            for (var i in dados) {
                if (dados[i].idFormaPagamento != 1 && dados[i].stFormaPagamento.toUpperCase().trim() != "DINHEIRO") {
                    var vrPF = parseFloat(dados[i].vrPagamento);

                    vrTotalReceita += parseFloat(dados[i].vrPagamento);
                    if (dados[i].totalAdq) vrTotalAdq += parseFloat(dados[i].totalAdq);
                    linha =
                        `<tr>
                            <td style="vertical-align: middle;">
                                <span id="icon"><i class="glyphicon glyphicon-chevron-right"></i></span>
                                <label class="tdStyle" id="lbl+${dados[i].idFormaPagamento}">
                                    <a onclick="modalFormaPagamento(${dados[i].idFormaPagamento}, ${idAbertura})">${dados[i].stFormaPagamento}</a>
                                </label>
                            </td>
                            <td>
                                <input style="text-align:right" name="${'vrN' + dados[i].idFormaPagamento}" id="${'n' + dados[i].idFormaPagamento}" data-tipo="parent" class="form-control" onkeydown="return setMoneyFormat(this, event, false)" onkeyup="setValores(this.id)" value="0.00"/>
                            </td>
                            <td>
                                <input style="text-align:right;" name="${'vrX' + dados[i].idFormaPagamento}" id="${'x' + dados[i].idFormaPagamento}" class="form-control" value="${(parseFloat(dados[i].vrPagamento).toFixed(2))}" readonly/>
                            </td>
                            <td>
                                <input style="text-align:right;" name="${'vrD' + dados[i].idFormaPagamento}" id="${'d' + dados[i].idFormaPagamento}" class="form-control" value="${(parseFloat("0.00" - dados[i].vrPagamento)).toFixed(2)}" readonly/>
                            </td>
                            <td style="vertical-align:middle;" class="oculta"><input type="button" class="bcalculator" onclick="abrirCalculadora(${dados[i].idFormaPagamento})"
                        </tr>`;
                    $(linha).appendTo($("#tbodyFormasPagamento"));
                }
            }
        }
        // seta valores de receita

        $("#totalReceita").val(parseFloat(vrTotalReceita).toFixed(2));
        // $("#totalAdq").val(parseFloat(vrTotalAdq).toFixed(2));
        var difReceita = (parseFloat($("#somaReceita").val()) - $('#totalReceita').val());
        $("#diferencaReceita").val(difReceita);
        checkValues();
    });
}

var x = false;

function toggle() {

}

function checkValues() {
    var inputs = $("input[name*='vrD']");
    for (var i = 0; i < inputs.length; i++) {
        if (inputs[i].value != 0.00) {
            inputs[i].style.borderColor = "red";
        } else {
            inputs[i].style.borderColor = "#CCCCCC";
        }
    }

    if ($("#diferencaReceita").val() != 0) {
        $("#diferencaReceita").css("border-color", "red");
    } else {
        $("#diferencaReceita").css("border-color", "#CCCCCC");
    }
}

function setValores(input) {
    var ids = input.split("_");

    var parentId = ids[0].replace(/\D/g, '');
    var parentInput = $('input[name=vrN' + parentId + ']');
    var parentTotal = $('input[name=vrX' + parentId + ']');
    var parentDiferenca = $('input[name=vrD' + parentId + ']');
    if (ids[1]) {
        var childId = ids[1].replace(/\D/g, '');
        var childInput = $('#nc' + parentId + "_" + childId);
        var childTotal = $('#xc' + parentId + "_" + childId);
        var childDiferenca = $('#dc' + parentId + "_" + childId);
        var childValue = 0;
        var childTotalValue = 0;

        if (ids[2]) {
            var ownId = ids[2].replace(/\D/g, '');
            var ownInput = $('#nsc' + parentId + "_" + childId + "_" + ownId);
            var ownTotal = $('#xsc' + parentId + "_" + childId + "_" + ownId);
            var ownDiferenca = $('#dsc' + parentId + "_" + childId + "_" + ownId);
            var diferenca = (parseFloat(ownInput.val()) - parseFloat(ownTotal.val())).toFixed(2);
            ownDiferenca.val(diferenca);

            $("input[id*=nsc" + parentId + "_" + childId + "]").each(function (i, el) {
                childValue += (parseFloat(this.value));
            });

            $("input[id*=xsc" + parentId + "_" + childId + "]").each(function (i, el) {
                childTotalValue += (parseFloat(this.value));
            });
            childInput.val(childValue.toFixed(2));
            childTotal.val(childTotalValue.toFixed(2));
            var diferenca = (childValue - parseFloat(childTotal.val())).toFixed(2);
            childDiferenca.val(diferenca);
            childValue = 0;
        }

        parentValue = 0;
        parentTotalValue = 0;
        $("input[id*=nc" + parentId + "]").each(function (i, el) {
            parentValue += (Number(this.value));
        });

        $("input[id*=xc" + parentId + "]").each(function (i, el) {
            parentTotalValue += (Number(this.value));
        });

        parentInput.val(parentValue.toFixed(2));
        parentTotal.val(parentTotalValue.toFixed(2));
        var diferenca = (parentValue - parseFloat(parentTotal.val())).toFixed(2);
        parentDiferenca.val(diferenca);
        parentValue = 0;
    } else {
        if (parentId == 1) {
            var diferenca = parseFloat(parentInput.val() - parentTotal.val() + (vrSangriaF + vrDespesaF)).toFixed(2);
            parentDiferenca.val(diferenca);
        } else {
            var diferenca = parseFloat(parentInput.val() - parentTotal.val()).toFixed(2);
            parentDiferenca.val(diferenca);
        }
    }

    var somaReceita = 0.00;
    $("input[data-tipo='parent']").each(function (i, el) {
        somaReceita += (Number(this.value));
    });
    var totalReceita = parseFloat(somaReceita + +vrDespesaF + vrSangriaF).toFixed(2);
    var diferencaReceita = (parseFloat(totalReceita) - parseFloat($("#totalReceita").val())).toFixed(2);
    $("#somaReceita").val(totalReceita);
    $("#diferencaReceita").val(diferencaReceita);
    checkValues();
}

function modalFormaPagamento(idFormaPagamento, idAbertura) {
    var data = {
        action: "getFormaPagamento",
        idAbertura: idAbertura,
        idFormaPagamento: idFormaPagamento
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        $("body").removeClass("loading");
        if (dados) {
            var teste = 0;
            var vrTotal = 0.00;
            var linha = '<table id="tableFormaPagamento" class="display table table-striped table-bordered">';
            linha += '<thead><tr><td class="tdStyle"><b>#</b></td><td class="tdStyle"><b>Cliente</b></td>';
            linha += '<td class="tdStyle"><b>Data</b></td><td class="tdStyle"><b>$ Venda</b></td><td class="tdStyle"><b>$ Pago</b></td>';
            linha += '<td class="tdStyle"><center><b>Troco / À Pagar</b></center></td><td class="tdStyle"><b>Valor Real Pago</b></td>';
            linha += '<td class="tdStyle oculta"><b>Ação</b></td></tr></thead><tbody>';
            for (var i = 0; i < dados.length; i++) {
                var rec = dados[i];

                linha += '<tr><td class="tdStyle"> ' + rec.idVenda + ' </td><td class="tdStyle"> ' + rec.stCliente + ' </td>';
                linha += '<td class="tdStyle"> ' + rec.dtData + ' </td><td class="tdStyle">R$ ' + parseFloat(rec.vrTotal).toFixed(2) + ' </td>';
                linha += '<td class="tdStyle">R$ ' + parseFloat(rec.vrFormaPagamento).toFixed(2) + ' </td>';
                linha += '<td class="tdStyle">';

                if (parseFloat(rec.vrFormaPagamento) < parseFloat(rec.vrTotal)) {
                    linha += 'À PAGAR:';
                } else if (parseFloat(rec.vrFormaPagamento) > parseFloat(rec.vrTotal)) {
                    linha += 'TROCO:';
                }

                var result = (parseFloat(rec.vrFormaPagamento) - parseFloat(rec.vrTotal));
                linha += ' R$ ' + parseFloat(result).toFixed(2) + '</td>';

                if (parseFloat(rec.vrFormaPagamento) < parseFloat(rec.vrTotal)) {
                    linha += '<td class="tdStyle">R$ ' + parseFloat(rec.vrFormaPagamento).toFixed(2) + '</td>';
                    vrTotal += parseFloat(rec.vrFormaPagamento);
                } else if (parseFloat(rec.vrFormaPagamento) > parseFloat(rec.vrTotal)) {
                    linha += '<td class="tdStyle">R$ ' + parseFloat(rec.vrTotal).toFixed(2) + '</td>';
                    vrTotal += parseFloat(rec.vrTotal);
                } else {
                    linha += '<td class="tdStyle">R$ ' + parseFloat(rec.vrTotal).toFixed(2) + '</td>';
                    vrTotal += parseFloat(rec.vrTotal);
                }

                linha += '<td class="oculta"><table width="100%" cellpadding="0" cellspacing="0"><tr><td class="tdStyle">';
                linha += '<center><a onclick="editarDetalheVenda(' + rec.idFormaPagamento + ',' + rec.idFicha + ',' + rec.idVenda + ')">';
                linha += '<span class="glyphicon glyphicon-edit" title="Editar"></span></a></center></td>';
                linha += '<td class="tdStyle"><center><a onclick="verDetalheVenda(' + rec.idFormaPagamento + ',' + rec.idVenda + ', 0)">';
                linha += '<span class="glyphicon glyphicon-search" title="Visualizar"></span></a></center></td></tr></table></td></tr>';
            }
            linha += '</tbody><tfoot><tr><td class="tdStyle" colspan="6"><b>TOTAL:</b></td><td class="tdStyle">';
            linha += '<b>R$ ' + vrTotal.toFixed(2) + '</b></td><td class="tdStyle oculta"></td></tr></tfoot></table>';
        } else {
            var linha = '<h4><b>Nenhum pagamento para mostrar</b></h4>';
        }
        $(linha).appendTo($("#divFormaPagamento"));
        initializeDataTables("tableFormaPagamento");
        $('#verFormaPagamento').modal('show');
    });
}

function printFormaPagamento(idFormaPagamento) {
    newWin = window.open("");
    newWin.document.write('<style> .oculta{ display: none;}</style>');
    var divToPrint = document.getElementById('tableFormaPagamento');
    newWin.document.write(divToPrint.outerHTML);
    newWin.print();
    newWin.close();
}

function editarDetalheVenda(idFormaPagamento, idFicha, idVenda) {
    $("body").addClass("loading");
    $("#verFormaPagamento").modal('hide');
    var linha = '<input id="idFormaPagamentoOld" value=' + idFormaPagamento + ' hidden/><input id="idFicha" value=' + idFicha + ' hidden/><input id="idVendaAlterar" value=' + idVenda + ' hidden/>';
    $(linha).appendTo($("#extraInfo"));
    var data = {
        action: "popularFormaPagamento"
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        $("body").removeClass("loading");
        for (var i = 0; i < dados.length; i++) {
            if (dados[i].idFormaPagamento == idFormaPagamento) {
                $('#idFormasPagamento').append($("<option></option>").attr("value", dados[i].idFormaPagamento).attr("selected", "selected").text(dados[i].stFormaPagamento));
            } else {
                $('#idFormasPagamento').append($("<option></option>").attr("value", dados[i].idFormaPagamento).text(dados[i].stFormaPagamento));
            }
        }
    });
    $("#alterarFormaPagamento").modal('show');
}

$("#alteraFormaPagamento").on("submit", function (e) {
    e.preventDefault();
    $("body").addClass("loading");
    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    var id = $("#idAbertura").val();
    var data = {
        action: 'alterarFormaPagamento',
        idAbertura: idAbertura,
        idFormaPagamento: $("#idFormasPagamento").val(),
        idFormaPagamentoOld: $("#idFormaPagamentoOld").val(),
        idFicha: $("#idFicha").val(),
        idVenda: $("#idVendaAlterar").val()
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        $("body").removeClass("loading");
        if (dados) {

            var inputAntigo = document.getElementsByName('vrX' + dados.idPagamentoAntigo);
            inputAntigo[0].value = (parseFloat(inputAntigo[0].value) - dados.vrValor).toFixed(2);

            iptOld = document.getElementsByName("vrN" + dados.idPagamentoAntigo + "")[0];
            setValores(iptOld.id);

            var inputNovo = document.getElementsByName('vrX' + dados.idPagamentoNovo);
            var temp = parseFloat(inputNovo[0].value) + dados.vrValor;
            inputNovo[0].value = parseFloat(temp).toFixed(2);

            iptNovo = document.getElementsByName("vrN" + dados.idPagamentoNovo + "")[0];
            setValores(iptNovo.id);
        } else {
            toastr.error(response.msg);
        }
    });
    $("#alterarFormaPagamento").modal('hide');
});

$("#idfechamento").on('submit', function (e) {
    e.preventDefault();
    toastr.options = {
        "positionClass": "toast-bottom-right"
    }
    $("body").addClass("loading");
    $.post('presidente/takeinsertfechamento.php', $("#idfechamento").serialize(), function (data) {
        $("body").removeClass("loading");
        if (data.status) {
            toastr.success(data.msg);
            setTimeout(function () {
                document.location = data.location
            }, data.time);
        } else {
            toastr.error(data.msg);
        }
    });
});

function verDetalheVenda(idFPagamento, idDetalheVenda, tipo) {

    switch (tipo) {
        case 0:
            $("#verFormaPagamento").modal('hide');
            break;
        case 1:
            $("#verTotalVendas").modal('hide');
            break;
        case 2:
            $("#verCValesRecebidos").modal('hide');
            break;
        case 3:
            $("#verVouchersRecebidos").modal('hide');
            $("#verVouchersEmitidos").modal('hide');
            break;
    }
    var id = $("#idAbertura").val();
    var data = {
        action: "getDetalheVenda",
        idAbertura: idAbertura,
        idVenda: idDetalheVenda
    };
    var vrTotal = 0.00;
    $("body").addClass("loading");
    $.post('presidente/resources/php/presidente_functions.php', data, function (dados) {
        console.log('dados: ', dados);
        if (dados) {
            var data = {
                action: "getDescontoDetalheVenda",
                idAbertura: id,
                idVenda: idDetalheVenda
            };
            $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
                console.log('response: ', response);
                if (response.status) {
                    $("#verDetalheVendaTitulo").html("Itens da venda " + idDetalheVenda);
                    var linha = '<input id="idFormaPagamento" value="' + idFPagamento + '" hidden/><input id="tipoModal" value="' + tipo + '" hidden/><table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse"><thead><tr><td class="tdStyle"><b>Operador</b></td><td class="tdStyle"><b>Código</b></td><td class="tdStyle"><b>Produto</b></td><td class="tdStyle"><b>Quantidade</b></td><td class="tdStyle"><b>Total</b></td></tr></thead><tbody>';
                    for (var i = 0; i < dados.length; i++) {
                        linha += '<tr><td class="tdStyle">' + dados[i].stAtendente + '</td><td class="tdStyle">' + dados[i].idCodProduto + '</td><td class="tdStyle">' + dados[i].stProduto + '</td><td class="tdStyle">' + dados[i].nrQuantidade + " " + dados[i].stMedida + '</td><td class="tdStyle">' + parseFloat(dados[i].vrTotal).toFixed(2) + '</td></tr>';
                        vrTotal += parseFloat(dados[i].vrTotal);
                    }
                    if (response.msg > 0.00) {
                        linha += '<tr><td class="tdStyle" colspan="3" width="80%"><b>DESCONTO:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(response.msg).toFixed(2) + ' </b></td></tr></tbody></table>';
                    }
                    linha += '<tr><td class="tdStyle" colspan="3" width="80%"><b>VALOR TOTAL:</b></td><td class="tdStyle" width="20%" colspan="2"><b>R$' + parseFloat(vrTotal).toFixed(2) + ' </b></td></tr></tbody></table>';
                } else {
                    var linha = '<h4><b>Nenhum detalhe para mostrar</b></h4>';
                }
                $(linha).appendTo($("#divDetalheVenda"));
                $("#verDetalheVenda").modal('show');
                $("body").removeClass("loading");
            });
        }
    });
}

function printModal() {

    var tableToPrint = $("#tableAberturaCaixa");
    newWin = window.open("");
    newWin.document.write(tableToPrint[0].outerHTML);
    newWin.print();
    newWin.close();
}

function abrirCalculadora(idFPagamento) {
    $("#formaPagamentoCalculadora").val(idFPagamento);
    $("#campoOperador").val(document.getElementsByName("vrN" + idFPagamento)[0].value);
    $("#campoMicro").val(document.getElementsByName("vrX" + idFPagamento + "")[0].value);
    $("#campoDiferenca").val(document.getElementsByName("vrD" + idFPagamento + "")[0].value);
    verificaCalculadora();

    var linha = '<div><input class="form-control" onkeydown="return setMoneyFormat(this, event, false)" onkeyup="setValoresCalculadora()" value = "' + $("#campoOperador").val() + '"/></div>';
    $(linha).appendTo($("#divCamposCalculadora"));
    $("#calculadora").modal('show');
}

function addCampoCalculadora() {
    var linha = '<br><div><input class="form-control" onkeydown="return setMoneyFormat(this, event, false)" onkeyup="setValoresCalculadora()" value = "0.00"/></div>';
    $(linha).appendTo($("#divCamposCalculadora"));
}

function removeCampoCalculadora() {
    if ($("#divCamposCalculadora").find("div").length > 1) {
        $("#divCamposCalculadora div:last").remove()
        $("#divCamposCalculadora br:last").remove()
        setValoresCalculadora();
    }
}

function setValoresCalculadora() {
    var total = 0.00;
    $("#divCamposCalculadora").find("input").each(function (i, el) {
        total += parseFloat(this.value);
    });
    $("#campoOperador").val(total.toFixed(2));
    $("#campoDiferenca").val((total - parseFloat($("#campoMicro").val())).toFixed(2));
    verificaCalculadora();
}

function verificaCalculadora() {
    if ($("#campoDiferenca").val() != 0) {
        $("#campoDiferenca").css("border-color", "red");
    } else {
        $("#campoDiferenca").css("border-color", "#CCCCCC");
    }
}

$("#resultadoCalculadora").on("submit", function (e) {
    e.preventDefault();
    var idFormaPagamento = $("#formaPagamentoCalculadora").val();
    var total = 0.00;
    $("#divCamposCalculadora").find("input").each(function (i, el) {
        total += parseFloat(this.value);
    });
    input = document.getElementsByName("vrN" + idFormaPagamento + "")[0];
    input.value = total.toFixed(2);
    setValores(input.id);
    $("#calculadora").modal('hide');
});

function checkVales() {
    chkAbrirRelatorio = $("#flMostrarVales").is(':checked');
    if (chkAbrirRelatorio > 0) {
        $("#tableVales").removeAttr("hidden");
    } else {
        $("#tableVales").attr("hidden", "hidden");
    }
}

function checkTaxas() {
    chkAbrirRelatorio = $("#flMostrarTaxas").is(':checked');
    if (chkAbrirRelatorio > 0) {
        $("#tableTaxas").removeAttr("hidden");
    } else {
        $("#tableTaxas").attr("hidden", "hidden");
    }
}

function newTurno() {
    $("#modalTurnos").modal('hide');
    $('.time').mask('00:00:00');
    $("#cadastroTurnos").modal('show');
}

function salvarTurno() {
    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    var desc = $("#descTurno").val();
    if (desc.length == 0) {
        $("#divDescTurno").addClass('has-error');
        toastr.error('Por favor, digite uma descrição para o turno.');
        return false;
    } else {
        $("#divDescTurno").removeClass('has-error');
    }

    var hrInicio = $("#hrInicial").val();
    horaInicio = hrInicio.split(":");
    if (hrInicio.length == 0) {
        $("#divHrInicial").addClass('has-error');
        toastr.error('Por favor, digite um horário de início do turno.');
        return false;
    } else {
        if (horaInicio[0] < 0 || horaInicio[0] > 23 || horaInicio[1] < 0 || horaInicio[1] > 59) {
            $("#divHrInicial").addClass('has-error');
            toastr.error('Horário de inicio de turno inválido.');
            return false;
        } else if (horaInicio[2]) {
            if (horaInicio[2] < 0 || horaInicio[2] > 59) {
                $("#divHrInicial").addClass('has-error');
                toastr.error('Horário de inicio de turno inválido.');
                return false;
            } else {
                $("#divHrInicial").removeClass('has-error');
            }
        } else {
            $("#divHrInicial").removeClass('has-error');
        }
    }
    var hrFim = $("#hrFinal").val();
    horaFim = hrFim.split(":");
    if (hrFim.length == 0) {
        $("#divHrFinal").addClass('has-error');
        toastr.error('Por favor, digite um horário de final do turno.');
        return false;
    } else {
        if (horaFim[0] < 0 || horaFim[0] > 23 || horaFim[1] < 0 || horaFim[1] > 59) {
            $("#divHrFinal").addClass('has-error');
            toastr.error('Horário de final de turno inválido.');
            return false;
        } else if (horaFim[2]) {
            if (horaFim[2] < 0 || horaFim[2] > 59) {
                $("#divHrFinal").addClass('has-error');
                toastr.error('Horário de final de turno inválido.');
                return false;
            } else {
                $("#divHrFinal").removeClass('has-error');
            }
        } else {
            $("#divHrFinal").removeClass('has-error');
        }
    }

    if (hrInicio > hrFim) {
        toastr.error('O horário do inicio do turno não pode ser mais tarde que o horário final.');
        $("#divHrInicial").addClass('has-error');
        $("#divHrFinal").addClass('has-error');
    } else {
        $("#divHrInicial").removeClass('has-error');
        $("#divHrFinal").removeClass('has-error');
    }

    var idTurno = $("#idTurno").val();
    if (idTurno) {
        var data = {
            action: 'editarTurno',
            idTurno: idTurno,
            stDesc: desc,
            hrInicio: hrInicio,
            hrFim: hrFim
        };
    } else {
        var data = {
            action: 'cadastraTurno',
            stDesc: desc,
            hrInicio: hrInicio,
            hrFim: hrFim
        };
    }
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response.status) {
            toastr.success(response.msg);
            setTimeout(function () {
                location.reload();
            }, 1000);
        } else {
            toastr.error(response.msg);
        }
    });
}

function deleteTurno(idTurno) {
    toastr.options = {
        "positionClass": "toast-bottom-right"
    };
    var data = {
        action: 'deleteTurno',
        idTurno: idTurno
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response.status) {
            toastr.success(response.msg);
            setTimeout(function () {
                location.reload();
            }, 1000);
        } else {
            toastr.error(response.msg);
        }
    });
}

function editTurno(idTurno) {
    var data = {
        action: 'getTurnoById',
        idTurno: idTurno
    };
    $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
        if (response) {
            $("#descTurno").val(response.stDescricao);
            $("#hrInicial").val(response.hrInicio);
            $("#hrFinal").val(response.hrFim);
            $("#idTurno").val(response.idTurno);
            newTurno();
        }
    });
}

function somarAbertura() {
    flSomaAbertura = !flSomaAbertura;

    vrAbertura = parseFloat($('#vrAbertura').val());
    vrSistema = parseFloat($('input[name=vrX1]').val());
    totalReceita = parseFloat($('#totalReceita').val());
    diferencaReceita = parseFloat($('#diferencaReceita').val());

    if (flSomaAbertura) {
        console.log('Somando abertura...');
        document.cookie = "somarAbertura=on"
        $('input[name=vrX1]').val((vrSistema + vrAbertura).toFixed(2));
        $('input[name=vrD1]').val((vrSistema + vrAbertura).toFixed(2));
        $('#totalReceita').val((totalReceita + vrAbertura).toFixed(2));
        $('#diferencaReceita').val((diferencaReceita + vrAbertura).toFixed(2));
    } else if (!flSomaAbertura) {
        console.log('Abertura removida...');
        document.cookie = "somarAbertura=off";
        $('input[name=vrX1]').val((vrSistema - vrAbertura).toFixed(2));
        $('input[name=vrD1]').val((vrSistema - vrAbertura).toFixed(2));
        $('#totalReceita').val((totalReceita - vrAbertura).toFixed(2));
        $('#diferencaReceita').val((diferencaReceita - vrAbertura).toFixed(2));
    }
    setValores('n1');
    checkValues();
}

(function () {
    setInterval(function () {
        data = {
            action: "initCaixa"
        };
        $.post('presidente/resources/php/presidente_functions.php', data, function (response) {
            if (response) {
                if (response.Unico) {
                    var vrTotal = 0.00;
                    var linha = '<div class="col-md-4 col-md-offset-4" align="center">';
                    linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><thead>';
                    linha += '<tr><th class="tdStyle">Data</th><th class="tdStyle">Caixa</th><th class="tdStyle">Operador</th><th class="tdStyle">Ação</th></tr>';
                    linha += '</thead><tbody>';
                    linha += '<tr><td colspan="4" align="center" style="padding:0px"><button type="button" class="btn btn-nati" style="width: 100%" onclick="openDetalhesCaixa(0)">Todos os Caixas</button></td></tr>';
                    for (var i = 0; i < response.Unico.length; i++) {
                        vrTotal += response.Unico[i].vrPagamento;
                        linha += '<tr><td class="tdStyle">' + response.Unico[i].dtAbertura + '</td><td class="tdStyle">Caixa ' + response.Unico[i].idCaixa + '</td><td class="tdStyle">' + response.Unico[i].stApelido + '</td>';
                        linha += '<td class="tdStyle" style="text-align:center"><a onclick="openDetalhesCaixa(' + response.Unico[i].idAbertura + ')"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                    }
                    linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></td></tr></tfoot></table></div>';
                } else {
                    var vrTotal = 0.00;
                    var turno = response.caixas[0].descTurno;
                    if (response.numTurnos == 1) {
                        divSize = '<div class="col-md-4 col-md-offset-4" align="center">';
                    } else if ((response.numTurnos % 2) == 0) {
                        divSize = '<div class="col-md-4 col-md-offset-1" align="center">';
                    } else {
                        divSize = '<div class="col-md-4" align="center">';
                    }
                    var linha = '<div class="col-md-12 form-group" align="center"><button type="button" class="btn btn-nati" onclick="openDetalhesCaixa(0)">Todos os Caixas</button></div>';
                    linha += divSize;
                    linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><caption class="table-caption">' + turno + '</caption><thead>';
                    linha += '<tr><th class="tdStyle" width="25%">Data</th><th class="tdStyle" width="25%">Caixa</th><th class="tdStyle" width="30%">Operador</th><th class="tdStyle" width="20%">Ação</th></tr>';
                    linha += '</thead><tbody>';
                    for (var i = 0; i < response.caixas.length; i++) {
                        if (response.caixas[i].descTurno == turno) {
                            vrTotal += parseFloat(response.caixas[i].vrPagamento);
                            linha += '<tr><td class="tdStyle">' + response.caixas[i].dtAbertura + '</td><td class="tdStyle">Caixa ' + response.caixas[i].idCaixa + '</td><td class="tdStyle">' + response.caixas[i].stApelido + '</td>';
                            linha += '<td class="tdStyle" style="text-align:center"><a onclick="openDetalhesCaixa(' + response.caixas[i].idAbertura + ')"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td></tr>';
                        } else {
                            turno = response.caixas[i].descTurno;
                            linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2);
                            +'</b></td></tr></tfoot>';
                            vrTotal = 0.00;
                            linha += '</table></div>';
                            linha += divSize;
                            linha += '<table class="display table table-striped table-bordered" cellspacing="0" width="100%"><caption class="table-caption">' + turno + '</caption><thead>';
                            linha += '<tr><th class="tdStyle" width="25%">Data</th><th class="tdStyle" width="25%">Caixa</th><th class="tdStyle" width="30%">Operador</th><th class="tdStyle" width="20%">Ação</th></tr>';
                            linha += '</thead><tbody>';
                            i--;
                        }
                    }
                    linha += '</tbody><tfoot><tr><td colspan="3" class="tdStyle"><b>Total do turno:</b></td><td class="tdStyle"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></td></tr></tfoot>';
                    linha += '</table></div>';
                }
            } else {
                var linha = '<div class="col-md-12" align="center"><h3>Nenhum caixa está aberto no momento!</h3></div><br>';
            }
            $('#divCaixasOnline').html('');
            $(linha).appendTo($("#divCaixasOnline"));
        });
    }, 60000)
})();
