<?php
require_once "../functions.php";

db_conn();

if (!autorization(7)){
	header("LOCATION: ../?sec=erro&sub=2");
	die;
}

$idAbertura = htmlspecialchars($_GET['id'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Detalhes de pagamentos em Contas Assinadas</title>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
	<link href="resources/css/toastr.css" rel="stylesheet"/>
	<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table width="100%" cellpadding="3" cellspacing="0">
		<caption class="table-caption"><b>Detalhes de pagamentos em Contas Assinadas</b></caption>
		<tr>
			<td class="tdStyle" colspan="2">
				<?php
				if (is_numeric($idAbertura)){
					$sql = "SELECT E.*, C.stCliente
					FROM cli_Extrato E
					INNER JOIN dlv_Clientes C ON E.idCliente = C.idCliente
					WHERE E.idAbertura = '$idAbertura' AND E.flAtivo = '1'";
				}else{
					$sql = "SELECT E.*, C.stCliente
					FROM cli_Extrato E
					INNER JOIN dlv_Clientes C ON E.idCliente = C.idCliente
					INNER JOIN cx_Gerenciador G ON G.idAbertura = E.idAbertura
					WHERE G.flAberto = '1' AND E.flAtivo = '1'";
				}

                //echo $sql.'<br /><br />';

				$res = mssql_query($sql);

				while ($arr = mssql_fetch_array($res)){
					$vrDescontoFinal = $arr['vrDesconto'];
					$vrQuitadoFinal = $arr['vrQuitado'];

					if (is_numeric($idAbertura)){
						$sql = "SELECT E.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, E.vrDesconto, E.vrQuitado, E.vrAcrescimo, I.vrTotal
						FROM cli_Extrato E
						INNER JOIN cli_ItemExtrato I ON E.idExtrato = I.idExtrato AND E.idAbertura = I.idAbertura
						INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
						INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
						WHERE E.idAbertura = '$idAbertura' AND I.flAtivo = '1' AND E.idExtrato = '".$arr['idExtrato']."'";
					}else{
						$sql = "SELECT E.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, E.vrDesconto, E.vrQuitado, E.vrAcrescimo, I.vrTotal
						FROM cli_Extrato E
						INNER JOIN cli_ItemExtrato I ON E.idExtrato = I.idExtrato AND E.idAbertura = I.idAbertura
						INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
						INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
						INNER JOIN cx_Gerenciador G ON G.idAbertura = E.idAbertura
						WHERE G.flAberto = '1' AND I.flAtivo = '1' AND E.idExtrato = '".$arr['idExtrato']."' AND E.idAbertura = '".$arr['idAbertura']."'";
					}

                        //echo $sql.'<br />'; exit;

					$rs = mssql_query($sql);

					$flQuit = true;
					$flDesc = true;
					$flCliente = true;
					$somaTotal = 0;
					?>
					<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
						<?
						while ($ar = mssql_fetch_array($rs))
						{
							$dtData = strtotime($ar['dtData']);
							$dtData = date("d/m/y H:i", $dtData);

							if ($ar['flFracionado'])
								$nrQuantidade = number_format(($ar['nrQuantidade'] / 1000), 3, ".", "");
							else
								$nrQuantidade = intval($ar['nrQuantidade']);

							if ($flCliente)
							{
								?>
								<thead>
									<tr>
										<td class="tdStyle" width="80%" colspan="2"><b><?php echo $arr['stCliente']?></b></td>
										<td class="tdStyle" width="20%" align="right"><?php echo $dtData?></td>
									</tr>
								</thead>
								<?
								$flCliente = false;
							}

							if ($ar['vrQuitado'] != 0 && $flQuit == true)
							{
								?>
								<tr>
									<td class="tdStyle" width="80%" colspan="2">VALOR QUITADO</td>
									<td class="tdStyle" width="60%" align="right">R$ <?php echo number_format($ar['vrQuitado'], 2, ",", ".")?></td>
								</tr>
								<?

								$flQuit = false;
							}

							if ($ar['vrDesconto'] != 0 && $flDesc == true)
							{
								?>
								<tr>
									<td class="tdStyle" width="80%" colspan="2">DESCONTO</td>
									<td class="tdStyle" width="60%" align="right">R$ <?php echo number_format($ar['vrDesconto']*(-1), 2, ",", ".")?></td>
								</tr>
								<?

								$flDesc = false;
							}

							?>
							<tr>
								<td class="tdStyle" width="60%"><?php echo $ar['stProduto']?></td>
								<td class="tdStyle" width="20%"><?php echo  ($ar['flFracionado'] ? $nrQuantidade : intval($ar['nrQuantidade'])) ?> <?php echo $ar['stMedida']?></td>
								<td class="tdStyle" width="20%" align="right">R$ <?php echo number_format($ar['vrTotal'], 2, ",", ".")?></td>
							</tr>
							<?
							$somaTotal += $ar['vrTotal'];
						}
						?>
						<tr>
							<td class='tdStyle' colspan='2'><font size='2'><b>VALOR TOTAL:</b></td>
							<td class='tdStyle' align='right'><font size='2'><b>R$ <?php echo  number_format($somaTotal + $vrDescontoFinal - $vrQuitadoFinal, 2, ",", ".") ?></b></td>
						</tr>
						<?
					}
					?>
				</table>
			</td>
		</tr>
	</table>
</body>
</html>
