var produtos = [];
document.addEventListener("DOMContentLoaded", function () {

    initialiseDataTable();
    $("body").addClass("loading");
    initSelect2();

    $('#selectItemAdicional').on("select2:select", function (e) {
        adicionar();
        $('#selectItemAdicional').val(null).trigger("change");
        setTimeout(function () {
            $('#selectItemAdicional').select2("open");
        }, 750);
    });
    gerarListaProdutos();
});

function initialiseDataTable() {

    $('#table_produtos').DataTable({
        retrieve: true,
        data: produtos,
        columns: [{
            title: "Codigo",
            data: 'idCodigo'
        },
            {
                title: "Produto",
                data: 'stProduto'
            },
            {
                title: "Medida",
                data: 'stMedida'
            },
            {
                title: "Remover",
                data: 'idProduto',
                className: 'text-center',
                orderable: false,
                searchable: false,
                render: function (data) {
                    return "<a href='#' onclick=removeProduto(" + data + ") style='font-size:15px;'><span class='glyphicon glyphicon-remove'></span></a>"
                }
            }],
    });
}

function gerarListaProdutos() {
    $('body').addClass('loading');
    produtos = [];
    $.post('transfer/resources/functions.php', {action: 'getProdutosPersonalizados'}, function (response) {
        if (response.length) {
            produtos = response;
        } else {
            adicionarAntigos();
        }
    }).always(() => {
        setTimeout(() => {
            $('body').removeClass('loading');
            updateListaProdutos();
        }, 2000);
    });
}

function removeProduto(id) {
    const itemId = produtos.findIndex(it => it.idProduto == id);
    produtos.splice(itemId, 1);

    const lista = getListaProduto();
    const data = {action: 'removerProduto', produtos: lista, id: id};
    $.post('transfer/resources/functions.php', data);

    updateListaProdutos();
}

function initSelect2() {
    $('#selectItemAdicional').select2({
        placeholder: "Digite o Código ou o Nome do Produto",
        multiple: false,
        minimumInputLength: 1,
        width: '100%',
        theme: "bootstrap",
        ajax: {
            url: "transfer/resources/functions.php",
            dataType: 'json',
            type: "POST",
            delay: 250,
            data: function (params) {
                return {
                    action: 'popularProduto',
                    texto: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.idCodigo + " - " + item.stProduto + ' - ' + item.stMedida,
                            id: item.idProduto
                        }
                    })
                }
            }
        }
    });
}

function getListaProduto() {
    var data = [];
    console.log(produtos)
    for (var i = 0; i < produtos.length; i++) {

        data.push(produtos[i]['idProduto']);
    }
    return JSON.stringify(data);
}

function adicionar() {
    var listaProdutos = getListaProduto();

    toastr.options = {"positionClass": "toast-bottom-right"};
    var id = $('#selectItemAdicional').val();

    if (!id) {
        toastr.warning('Selecione um produto');
        return false;
    }

    var data = {action: 'adicionarProduto', id: id, produtos: listaProdutos};
    for (var i = 0; i < produtos.length; i++) {
        if (id === produtos[i]['idProduto']) {
            toastr.error('Produto já está na lista');
            return false;
        }
    }
    $.post('transfer/resources/functions.php', data, function (response) {
        if (response) {
            produtos.push(response[0]);
            updateListaProdutos();
        }
    });
}


function adicionarFracionados() {
    var notAdd = [];
    for (var i = 0; i < produtos.length; i++) {
        notAdd.push(parseInt(produtos[i]['idProduto']));
    }
    notAdd = JSON.stringify(notAdd);
    var data = {action: 'adicionarFracionados', skip: notAdd};
    $.post('transfer/resources/functions.php', data, function (response) {
        if (response) {
            for (var i = 0; i < response.length; i++) {
                produtos.push(response[i]);
            }
            updateListaProdutos();
        }
    });
}

function adicionarAntigos() {
    // swal("Aviso!", "Adicionar produtos antigos é uma função legado que será removida posteriormente.", "info");
    var notAdd = [];
    for (var i = 0; i < produtos.length; i++) {
        notAdd.push(produtos[i]['idProduto']);
    }
    notAdd = JSON.stringify(notAdd);
    var listaProdutos = getListaProduto();
    var data = {action: 'adicionarAntigos', skip: notAdd, produtos: listaProdutos};
    $.post('transfer/resources/functions.php', data, function (response) {
        if (response) {
            for (var i = 0; i < response.length; i++) {
                produtos.push(response[i]);
            }
            updateListaProdutos();
        }
    });
}

function limparLista() {
    swal({
        title: "Tem certeza?",
        text: "Não será possível recuperar a lista de produtos depois disso!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#dd6b55",
        confirmButtonText: "Sim, deletar!",
        cancelButtonText: "Não, cancelar!",
        showLoaderOnConfirm: true,
    }, function () {
        $.post('transfer/resources/functions.php', {action: 'removerTodos'});
        produtos = [];
        updateListaProdutos();
    });
}

function updateListaProdutos() {

    produtos.sort(function (a, b) {
        var x = parseInt(a['idCodigo']);
        var y = parseInt(b['idCodigo']);
        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
    });

    $('#table_produtos').DataTable().destroy();
    initialiseDataTable();
}

function gerar() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    if (produtos.length === 0) {
        toastr.error('Deve ser selecionado pelo menos um produto');
        return false;
    }
    $("body").addClass("loading");
    $('#divPickProdutos').addClass('hidden');
    for (var i = 0; i < produtos.length; i++) {
        produtos[i] = produtos[i]['idProduto'];
    }
    var listaProdutos = JSON.stringify(produtos);
    var imp = '';
    var adc = '';
    $('input[id^="contEx"]').each(function () {
        if ($(this).is(':checked')) {
            adc = $(this).val();
        }
    });

    $('input[id^="impressora"]').each(function () {
        if ($(this).is(':checked')) {
            imp = $(this).val();
        }
    });
    var data = {action: 'gerarArquivos', produtos: listaProdutos, impressora: imp, adicional: adc};
    $.post('transfer/resources/functions.php', data, function (response) {
        $("body").removeClass("loading");
        if (response) {
            $('#divBaixar').removeClass('hidden');
            if (response.status) {
                $('#sucesso').removeClass('hidden');
                if (imp == 'prix4') {
                    $('#btnPrix').removeClass('hidden');
                    $('#btnFili').addClass('hidden');
                } else if (imp == 'platina') {
                    $('#btnFili').removeClass('hidden');
                    $('#btnPrix').addClass('hidden');
                }
            } else {
                $('#erro').removeClass('hidden');
            }
        }
    });
}

function voltar() {
    $('#btnFili').addClass('hidden');
    $('#btnPrix').addClass('hidden');
    $('#divBaixar').addClass('hidden');
    $('#divPickProdutos').removeClass('hidden');
    gerarListaProdutos();
}

