<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SaldoEstoque extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'est_Saldos';
    protected $primaryKey = 'idSaldo';
    public $timestamps = false;

    protected $fillable = [
        'idSaldo',
        'idEstoque',
        'idProduto',
        'nrQuantidade',
        'nrReservas',
        'dtModificacao',
        'dtConferencia',
        'nrMinimo',
        'dtAlteracao',
        'nrConferido'
    ];

    public function estoque() {
        return $this->belongsTo('App\Entities\Nati\Estoque', 'idEstoque', 'idEstoque');
    }
}
