<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 27/11/2017
 * Time: 16:34
 */

namespace App\Services;


use App\Repositories\ClosingHistoryRepository;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class ClosingHistoryService
{
    protected $repository;

    public function __construct(ClosingHistoryRepository $repository)
    {
        $this->repository = $repository;
    }

    public function get()
    {
        $this->repository->all();
    }

    /**
     * @param array  $data
     * @param string $idAbertura
     * @return Model
     */
    public function insert($data, string $idAbertura)
    {
        $today = Carbon::now();
        $data = [
            'idAbertura' => $idAbertura,
            'vrApurado' => $data['operador'],
            'vrFechamento' => $data['sistema'],
            'vrDiferenca' => $data['diferenca'],
            'dtData' => $today,
            'dtAlteracao' => $today
        ];

        return $this->repository->create($data);
    }
}
