<?php

namespace App\Services;

use App\Entities\Master;
use App\Validators\MasterValidator;
use App\Repositories\MasterRepository;
use Illuminate\Support\Facades\Cache;
use Prettus\Validator\Contracts\ValidatorInterface;

class MasterService
{
    private $repository;
    private $validator;

    public function __construct(MasterRepository $repository, MasterValidator $validator)
    {
        $this->validator = $validator;
        $this->repository = $repository;
    }
    public function getById($id){
        return $this->repository->find($id);
    }

    public function get()
    {
//        if(Cache::has('master'))
//        {
//            return Cache::get('master');
//        }

        $response = $this->repository->first();

//        Cache::put('master', $response, 1440);

        return $response;
    }

    public function update($data, $id)
    {
        if(isset($data['nati_key'])) {
            $day = substr($data['nati_key'], 7, 2);
            $month = substr($data['nati_key'], 24, 2);
            $year = substr($data['nati_key'], 41, 4);
            $data['validate'] = "{$year}-{$month}-{$day}";

            $key = str_replace("-{$day}-", '', $data['nati_key']);
            $key = str_replace("-{$month}-", '', $key);
            $key = str_replace("-{$year}-", '', $key);
            $data['activation_key'] = str_replace('-', '', $key);
        }

        $data['stLetraComanda'] = strtoupper($data['stLetraComanda']);

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($data, $id);
    }

    public function updateToken($token, $id)
    {
        return Master::where('idCliente', $id)
                    ->update(['subAccountToken' => $token]);
    }
}
