<?php

namespace App\Services\Nati;

use Illuminate\Support\Facades\Cache;
use App\Entities\Nati\Measure;
use App\Entities\Nati\Product;
use App\Repositories\Nati\MeasureRepository;
use App\Validators\Nati\MeasureValidator;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class MeasureService
{
    private $repository;
    private $validator;


    public function __construct(MeasureRepository $repository, MeasureValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getById($id)
    {
        return $this->repository->withCount('produtos')->find($id);
    }

    public function all()
    {
        if(Cache::has('ListaMedidas')){
            return Cache::get('ListaMedidas');
        }else{
            $response = $this->repository->withCount('produtos')->all();
            Cache::put('ListaMedidas', $response, 1440);
            return $response;
        }
    }

    public function create($request)
    {
        $medida = [
            "idMedida" => $this->getNextId(),
            "stMedida" => $request['stMedida'],
            "flFracionado" => $request['flFracionado'],
            "flAtivo" => true,
            "dtAlteracao" => Carbon::now(),
            "stDescricao" => "",
            'sync' => false
        ];
        $this->validator->with($medida)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($medida);
    }

    public function update($request, $id)
    {
        $medida = [
            "stMedida" => $request['stMedida'],
            "flFracionado" => $request['flFracionado'],
            "dtAlteracao" => Carbon::now(),
        ];

        $this->validator->with($medida)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($medida, $id);
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    private function getNextId()
    {
        return $medida = Measure::max('idMedida') + 1;
    }

    public function transfer($idMedida, $idMedidaNew)
    {

        $produto = Product::query()->where('idMedida', '=', $idMedida)->update(['idMedida' => $idMedidaNew, 'idMedidaCompra' => $idMedidaNew]);

//        $this->repository->update(['flAtivo' => true], $idMedidaNew);

        $this->repository->delete($idMedida);

        return $produto;
    }

    public function getOrCreate($medida)
    {
        $cat = $this->repository->where('stMedida', strtoupper($medida))->first();
        if($cat){
            return $cat;
        }else{
            return $this->create([
                'stMedida' => strtoupper($medida),
                'flFracionado' => $medida == 'UN'
                ]);
        }
    }
}
