<?php

namespace App\Services\Nati;

use App\Repositories\PontoDeliveryRepositoryEloquent;
use App\Services\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use App\Validators\PontoDeliveryValidator;

class PontoDeliveryService extends Service
{

    protected $repository;
    protected $validator;
    protected $keyService;


    public function __construct(PontoDeliveryRepositoryEloquent $repository, PontoDeliveryValidator $validator, KeyService $keyService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->keyService = $keyService;
    }

    public function get()
    {
        if (Cache::tags(['ListaPontosDelivery'])->has('all')) {
            return Cache::tags(['ListaPontosDelivery'])->get('all');
        } else {
            $response = $this->repository->findWhere(['flAtivo' => true]);
            Cache::tags(['ListaPontosDelivery'])->put('all', $response, 1440);
            return $response;
        }
    }

    public function getById($id)
    {
        return $this->repository->with('key')->find($id);
    }

    public function insert($request)
    {
        $request['stRodapeCupom'] = ' ';
        $request['stCabecalhoCupom1'] = ' ';
        $request['stCabecalhoCupom2'] = ' ';
        $request['stCabecalhoCupom3'] = ' ';
        $request['stCabecalhoCupom4'] = ' ';
        $request['stCidade'] = 'SAO PAULO';
        $request['stEstado'] = 'SP';
        $request['nrVias'] = '1';
        $request['flTaxaEntregaUnica'] = false;
        $request['vrTaxaEntregaUnica'] = 0;
        $request['nrAlertaEntrega'] = 0;
        $request['flSolicitarOperador'] = 0;
        $request['flAtivo'] = true;
        $request['flPrintCupomPreparo'] = false;
        $request['dtAlteracao'] = $this->getDate();
        $request['flPrintManager'] = false;
        $request['flAssumirPedido'] = false;
        $request['flHorarios'] = true;

        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return DB::transaction(function () use ($request) {

            $delivery = $this->repository->create($request);

            if (isset($request['key'])) {
                $this->keyService->setKey($request['key'], $request['idDelivery']);
            }
            return $delivery;
        });
    }

    public function update($request, $id)
    {

        $request['stRodapeCupom'] = ' ';
        $request['stCabecalhoCupom1'] = ' ';
        $request['stCabecalhoCupom2'] = ' ';
        $request['stCabecalhoCupom3'] = ' ';
        $request['stCabecalhoCupom4'] = ' ';
        $request['stCidade'] = 'SAO PAULO';
        $request['stEstado'] = 'SP';
        $request['nrVias'] = '1';
        $request['flTaxaEntregaUnica'] = false;
        $request['vrTaxaEntregaUnica'] = 0;
        $request['nrAlertaEntrega'] = 0;
        $request['flSolicitarOperador'] = 0;
        $request['flAtivo'] = true;
        $request['flPrintCupomPreparo'] = false;
        $request['dtAlteracao'] = $this->getDate();
        $request['flPrintManager'] = false;
        $request['flAssumirPedido'] = false;
        $request['flHorarios'] = true;

        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);


        return DB::transaction(function () use ($request, $id) {

            if (isset($request['key_value'])) {

                $this->keyService->setKey($request['key_value'], $request['idDelivery']);
            } else {

                $model = $this->getById($id);
                if(isset($model['key_value'])) {

                $this->keyService->unsetKey($model['key_value']);
                }
            }
            return $this->repository->update($request, $id);
        });
    }

    public function delete($id)
    {
        $delivery = $this->getById($id);

        return DB::transaction(function () use ($delivery, $id) {
            if ($delivery['key']) {
                $this->keyService->unsetKey($delivery['key']);
            }
            return $this->repository->delete($id);
        });
    }

    private function data($request)
    {
        $data = [
            'id' => $request['id'],
            'type_door' => $request['type_door'],
            'print' => $request['print'],
            'key' => isset($request['key']) ? $request['key'] : null,
            'DDD' => 11,
            'id_microterminal' => isset($request['id_microterminal']) ? $request['id_microterminal'] : null,
            'footer_coupon' => isset($request['footer_coupon']) ? $request['footer_coupon'] : " ",
            'header_coupon' => isset($request['header_coupon']) ? $request['header_coupon'] : " ",
            'header_coupon_2' => isset($request['header_coupon_2']) ? $request['header_coupon_2'] : " ",
            'header_coupon_3' => isset($request['header_coupon_3']) ? $request['header_coupon_3'] : " ",
            'header_coupon_4' => isset($request['header_coupon_4']) ? $request['header_coupon_4'] : " ",
            'city' => isset($request['city']) ? $request['city'] : "SAO PAULO",
            'state' => isset($request['city']) ? $request['city'] : "SP",
            'number_via' => 1,
            'is_single_taxe_delivery' => false,
            'value_single_taxe_delivery' => 0,
            'value_alert' => 0,
            'is_request_operator' => false,
            'active' => true,
            'is_print_coupon_prepare' => false,
            'is_print_manager' => false,
            'is_assume_order' => false,
            'is_hours' => true,
            'updated_at' => $this->getDate(),
        ];

        return $data;
    }
}
