<?php

namespace App\Services;

use App\Entities\Prints;
use App\Repositories\PrintsRepository;
use App\Validators\PrintsValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class PrintsService extends Service
{

    protected $repository;
    protected $validator;


    public function __construct(PrintsRepository $repository, PrintsValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->all();
    }

    public function getById($id)
    {
        return $this->repository->find($id);
    }

    public function create($data)
    {
        $data['id'] = $this->nextId();
        $data['updated_at'] = Carbon::now()->toDateTimeString();
        $data['canal'] = 'PC';
        $data['sync'] = false;

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($data);
    }

    public function update($data, $id)
    {
        $data['updated_at'] = Carbon::now()->toDateTimeString();
        $data['canal'] = isset($data['canal']) ? $data['canal'] : 'PC';
        $data['sync'] = false;

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    private function nextId()
    {
        return Prints::max('idPrint') + 1;
    }
}