<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstSaldosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Saldos')) {
            Schema::create('est_Saldos', function (Blueprint $table) {
                $table->integer('idSaldo', false, true);
                $table->integer('idEstoque', false, true);
                $table->integer('idProduto', false, true);
                $table->decimal('nrQuantidade', 15, 3)->default(0);
                $table->decimal('nrReservas', 15, 3)->default(0);
                $table->dateTime('dtModificacao');
                $table->dateTime('dtConferencia');
                $table->decimal('nrMinimo', 15, 3)->default(0);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Saldos');
    }
}
