<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdCodigosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Codigos')) {
            Schema::create('prd_Codigos', function (Blueprint $table) {
                $table->string('idCodigo', 14);
                $table->integer('idProduto', false, true);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->boolean('flPrincipal')->default(false);
                $table->decimal('vrMultiplo',18, 3)->default(1);
                $table->primary(['idCodigo', 'idProduto']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Codigos');
    }
}
