<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V54Migrations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->changeVendasTable();
        $this->changeVendasTempTable();
        $this->changeMicroterminaisTable();
        $this->changeDlvConfig();
    }

    private function changeVendasTable()
    {
        if (Schema::hasTable('cx_Vendas')) {
            if (!Schema::hasColumn('cx_Vendas', 'chave_fiscal')) {
                Schema::table('cx_Vendas', function (Blueprint $table) {
                    $table->string('chave_fiscal', 47)->nullable();
                });
            }
        }
    }

    private function changeVendasTempTable()
    {
        if (Schema::hasTable('cx_Vendas_Temp')) {
            if (!Schema::hasColumn('cx_Vendas_Temp', 'chave_fiscal')) {
                Schema::table('cx_Vendas_Temp', function (Blueprint $table) {
                    $table->string('chave_fiscal', 47)->nullable();
                });
            }
        }
    }
    private function changeMicroterminaisTable(){
        if (Schema::hasTable('mt_Microterminais')) {
            if (Schema::hasColumn('mt_Microterminais', 'nrPorta')) {
                Schema::table('mt_Microterminais', function (Blueprint $table) {
                    $table->integer('nrPorta')->nullable()->change();
                });
            }
        }
    }

    private function changeDlvConfig(){
        if (Schema::hasTable('dlv_Config')) {
            if (Schema::hasColumn('dlv_Config', 'stLinkPagtel')) {
                Schema::table('dlv_Config', function (Blueprint $table) {
                    $table->dropColumn('stLinkPagtel');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
