<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinCredenciadorasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_Credenciadoras')) {

            DB::statement('CREATE TABLE [dbo].[fin_Credenciadoras](
                  [idCredenciadora] [smallint] IDENTITY(1,1) NOT NULL,
                  [codigoCredenciadora] [smallint] NOT NULL,
                  [stCredenciadora] [nvarchar](30) NOT NULL,
                  [stCnpj] [nvarchar](20) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_fin_Credenciadoras_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_fin_Credenciadoras] PRIMARY KEY CLUSTERED
                    (
                      [idCredenciadora] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_Credenciadoras');

    }
}
