<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SpedTipoItemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('sped_TipoItem')->count()) {

            $data = [
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '00', 'stDescricao' => 'Mercadoria para Revenda'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '01', 'stDescricao' => 'Matéria-Prima'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '02', 'stDescricao' => 'Embalagem'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '03', 'stDescricao' => 'Produto em Processo'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '04', 'stDescricao' => 'Produto Acabado'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '05', 'stDescricao' => 'Subproduto'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '06', 'stDescricao' => 'Produto Intermediário'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '07', 'stDescricao' => 'Material de Uso e Consumo'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '08', 'stDescricao' => 'Ativo Imobilizado'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '09', 'stDescricao' => 'Serviços'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '10', 'stDescricao' => 'Outros Insumos'],
                ['dtAlteracao' => Carbon::now(), 'nrTipoItemSped' => '99', 'stDescricao' => 'Outras'],
            ];

            DB::table('sped_TipoItem')->insert($data);

        }
    }
}
