var medidas = [];
document.addEventListener("DOMContentLoaded", function() {
    var data = {action: 'getMedidas'};
    toastr.options = {"positionClass": "toast-bottom-right"};
    $.post('produtos/resources/php/medidas_functions.php', data, function(dados) {
        if (dados) {
            medidas = dados;
            var linha = '';
            var fracionado = 'Não';
            for (var i = 0; i < dados.length; i++) {
                if (dados[i].flFracionado == true) {
                    fracionado = 'Sim';
                }else{
                    fracionado = 'Não';
                }
                linha += '<tr><td class="tdStyle">'+dados[i].stMedida+'</td>';
                linha += '<td class="tdStyle">'+fracionado+'</td>';
                linha += '<td class="tdStyle">';
                linha += '<a onclick="editMedida('+dados[i].idMedida+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a onclick="askExcluir('+dados[i].idMedida+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
                $('#selectTrocaMedida').append($("<option></option>").attr("value", dados[i].idMedida).text(dados[i].stMedida));
            }
            $(linha).appendTo($("#bodyTabelaMedidas"));
        }
    });
});

function novaMedida () {
    $("#modalMedidaTitle").html('Cadastro de Medida');
    $("#modalMedida").modal('show');
}

function editMedida (idMedida) {
    var medida = null;
    for (var i = 0; i < medidas.length; i++) {
        if(medidas[i]['idMedida'] == idMedida){
            medida = medidas[i];
        }
    }
    $("#codigoMedida").val(medida.idMedida);
    $("#stMedida").val(medida.stMedida);
    $("#flFracionado").val(medida.flFracionado);
    $("#modalMedidaTitle").html('Edição de Medida');
    $("#modalMedida").modal('show');
}

function cadastrarMedida() {
    var idMedida = $("#codigoMedida").val();
    var stMedida = $("#stMedida").val();
    if (stMedida.length == 0) {
        toastr.error('Digite um nome para a medida!');
        $("#divStMedida").addClass('has-error');
        return false;
    }
    var flFracionado = $("#flFracionado").val();
    var action = 'cadastrarMedida';
    if(idMedida){
        action = 'editarMedida';
        var data = {action: action, idMedida: idMedida, stMedida: stMedida, flFracionado: flFracionado};
    }else{
        var data = {action: action, stMedida: stMedida, flFracionado: flFracionado};
    }
    $.post('produtos/resources/php/medidas_functions.php', data, function(dados) {
        if(dados.status){
            toastr.success(dados.msg);
            setTimeout(function(){location.reload();},1000);
        }else{
            toastr.error(dados.msg);
        } 
    });
}

function askExcluir(idMedida) {
    if (medidas.length == 1) {
        swal('Erro!', 'Não é possível excluir a única medida disponível', 'error');
        return false;
    }
    swal({   
        title: 'Tem certeza?',   
        text: 'Tem certeza que deseja excluir esta medida?',   
        type: 'warning',   
        showCancelButton: true,   
        confirmButtonColor: '#2A98D3',   
        cancelButtonColor: '#FF2727',   
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',   
        closeOnConfirm: true 
    }, function() { 
        $('#oldMedida').val(idMedida);
        $('#modalTroca').modal('show');
    });
};

function excluirMedida() {
    $("body").addClass("loading");
    var idMedida = $('#oldMedida').val();
    var idNova = $('#selectTrocaMedida').val();
    var data = {action: "excluirMedida", idMedida: idMedida, idNovaMedida: idNova};
    $.post('produtos/resources/php/medidas_functions.php', data, function (response) {
        $("body").removeClass("loading");
        if(response.status){
            toastr.success(response.msg);
            setTimeout(function(){location.reload();},1000);
        }else{
            toastr.error(response.msg);
        }          
    });
}

$('#modalMedida').on('hidden.bs.modal', function (e) {
  $("#divStMedida").removeClass('has-error');
  $("#stMedida").val('');
})