<?php
header('Content-type: application/json');
chdir(dirname(realpath(__FILE__)));
require_once "../../functions.php";
db_conn();
if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'getProdutosPersonalizados':
            getProdutosPersonalizados();
            break;
        case 'popularProduto':
            popularProduto(isset($_POST['texto']) ? $_POST['texto'] : '');
            break;
        case 'adicionarProduto':
            adicionarProduto(isset($_POST['id']) ? $_POST['id'] : '', isset($_POST['produtos']) ? $_POST['produtos'] : '');
            break;
        case 'gerarArquivos':
            gerarArquivos(isset($_POST['produtos']) ? $_POST['produtos'] : '', isset($_POST['impressora']) ? $_POST['impressora'] : '', isset($_POST['adicional']) ? $_POST['adicional'] : '');
            break;
        case 'adicionarInteiros':
            adicionarInteiros(isset($_POST['skip']) ? $_POST['skip'] : '');
            break;
        case 'adicionarFracionados':
            adicionarFracionados(isset($_POST['skip']) ? $_POST['skip'] : '');
            break;
        case 'adicionarAntigos':
            adicionarAntigos(isset($_POST['skip']) ? $_POST['skip'] : '', isset($_POST['produtos']) ? $_POST['produtos'] : '');
            break;
        case 'removerProduto':
            removerProduto(isset($_POST['id']) ? $_POST['id'] : '',isset($_POST['produtos']) ? $_POST['produtos'] : '');
            break;
        case 'removerTodos':
            removerTodos();
            break;
    }
}


function getProdutosPersonalizados()
{
	$qry = "SELECT CAST(stBalanca AS TEXT) AS stBalanca FROM prd_Config";
    $res = mssql_fetch_array(mssql_query($qry));
    $produtos = json_decode($res[0]);

    if ($produtos) {
		$listaProdutos = '';
		for ($i=0; $i < count($produtos); $i++) {
			$listaProdutos .= $produtos[$i] . ',';
		}
		$listaProdutos = substr($listaProdutos,0, -1);

		$qry = "SELECT p.idProduto, p.stProduto, m.stMedida FROM prd_Produtos p
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
		WHERE p.flAtivo = 1 AND p.idProduto in ($listaProdutos)
		ORDER BY p.stProduto";

		$res = mssql_query($qry);
		while ($arr = mssql_fetch_assoc($res)) {
			$arr['stProduto'] = utf8_encode($arr['stProduto']);
			$newQry = "SELECT MIN(CONVERT(decimal, idCodigo))as idCodigo FROM prd_Codigos WHERE idProduto = ".$arr['idProduto'];
			$newRes = mssql_fetch_array(mssql_query($newQry));
			$arr['idCodigo'] = $newRes[0];
			$rows[] = $arr;
		}
		echo json_encode($rows);
	}else{
		$rows = [];
		echo json_encode($rows);
	}
}

function popularProduto($texto){
	if (strlen($texto) > 0) {
		if(ctype_digit($texto)){
			$qry =	"SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo, m.stMedida FROM prd_Produtos p
			INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
			INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
			WHERE c.idCodigo LIKE '".$texto."%' AND p.flAtivo = '1' AND LEN(c.idCodigo) <= 6 AND convert(decimal, c.idCodigo) > 0";
		}else{
			$qry = "SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo , m.stMedida FROM prd_Produtos p
			INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
			INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
			WHERE stProduto LIKE '".$texto."%' AND P.flAtivo = '1' AND LEN(c.idCodigo) <= 6 AND convert(decimal, c.idCodigo) > 0";
		}
		$res = mssql_query($qry);
		while($arr = mssql_fetch_assoc($res))
		{
			$arr['stProduto'] = utf8_encode($arr['stProduto']);
			$rows[] = $arr;
		}
		echo json_encode(isset($rows) ? $rows : array());
	}
}

function adicionarProduto($id, $produtos)
{
	$produtos = substr($produtos, 0, -1);
	if (strlen($produtos) == 1) {
		$produtos .= $id.']';
	}else{
		$produtos .= ','.$id.']';
	}
	$qry = "UPDATE prd_Config SET stBalanca = '$produtos'";
	mssql_query($qry);
    $sql = "SELECT MIN(c.idCodigo) as idCodigo, p.idProduto, p.stProduto, m.stMedida FROM prd_Produtos p
            INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
            INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
            WHERE p.flAtivo = 1 AND p.idProduto = $id
            GROUP BY p.idProduto, p.stProduto, m.stMedida
            ORDER BY idCodigo";
	$res = mssql_query($sql);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stProduto'] = utf8_encode($arr['stProduto']);
		$rows[] = $arr;
	}
	echo json_encode(isset($rows) ? $rows : array());
}


function adicionarFracionados($skip)
{
	$notin = str_replace('[', '', $skip);
	$notin = str_replace(']', '', $notin);

	$sql = "SELECT c.idCodigo, p.idProduto, p.stProduto, m.stMedida FROM prd_Produtos p
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
	INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
	WHERE p.flAtivo = 1 AND LEN(c.idCodigo) <= 6 AND convert(decimal, c.idCodigo) > 0
	AND m.idMedida = 2 ";
	// AND m.flFracionado = 1 ";
	if (strlen($notin) > 0) {
		$sql .= "AND p.idProduto NOT IN ($notin)";
	}
	$sql .= "ORDER BY CONVERT(decimal, c.idCodigo)";
	$res = mssql_query($sql);
	$skip = str_replace(']', '', $skip);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stProduto'] = utf8_encode($arr['stProduto']);
		$rows[] = $arr;
		$skip .= ','. $arr['idProduto'];
	}

	if (strpos($skip, ',') == 1) {
		var_dump('remove ,');
	}
	echo json_encode($rows);
}

function adicionarAntigos($skip, $produtos)
{
	$notin = '';
	$skip = json_decode($skip);
	for ($i=0; $i < count($skip) ; $i++) {
		$notin .= $skip[$i].',';
	}
	$notin = rtrim($notin, ',');

	$produtos = substr($produtos, 0, -1);

	$sql = "SELECT c.idCodigo, p.idProduto, p.stProduto, m.stMedida FROM prd_Produtos p
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
	INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
	WHERE p.flAtivo = 1 AND LEN(c.idCodigo) <= 6 AND convert(decimal, c.idCodigo) > 0
	AND p.flBalanca = 1 ";
	if (strlen($notin) > 0) {
		$sql .= "AND p.idProduto NOT IN (".$notin.")";
	}
	$sql .= "ORDER BY CONVERT(decimal, c.idCodigo)";
	$res = mssql_query($sql);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stProduto'] = utf8_encode($arr['stProduto']);
		$produtos .= $arr['idProduto']. ', ';
		$rows[] = $arr;
	}
	$produtos .= ']';
	$qry = "UPDATE prd_Config SET stBalanca = '$produtos'";
	mssql_query($qry);

	echo json_encode($rows);
}

function removerProduto($id, $produtos){
    $qry = "UPDATE prd_Config SET stBalanca = '$produtos'";
    mssql_query($qry);

    $qry = "UPDATE prd_Produtos SET [flBalanca] = 0 WHERE [idProduto] = $id";
    mssql_query($qry);
}

function removerTodos(){
    $qry = "UPDATE prd_Config SET stBalanca = '[]'";
    mssql_query($qry);

    $qry = "UPDATE prd_Produtos SET [flBalanca] = 0";
    mssql_query($qry);
}

function cleanString($text) {
    $utf8 = array(
        '/[áàâãªä]/u'   =>   'a',
        '/[ÁÀÂÃÄ]/u'    =>   'A',
        '/[ÍÌÎÏ]/u'     =>   'I',
        '/[íìîï]/u'     =>   'i',
        '/[éèêë]/u'     =>   'e',
        '/[ÉÈÊË]/u'     =>   'E',
        '/[óòôõºö]/u'   =>   'o',
        '/[ÓÒÔÕÖ]/u'    =>   'O',
        '/[úùûü]/u'     =>   'u',
        '/[ÚÙÛÜ]/u'     =>   'U',
        '/ç/'           =>   'c',
        '/Ç/'           =>   'C',
        '/ñ/'           =>   'n',
        '/Ñ/'           =>   'N',
        '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
        '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
        '/[“”«»„]/u'    =>   ' ', // Double quote
        '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
    );
    return preg_replace(array_keys($utf8), array_values($utf8), $text);
}

function gerarArquivos($produtos, $impressora, $adicional)
{
	$erro = false;
	$qry = "UPDATE prd_Config SET stBalanca = '$produtos'";
	mssql_query($qry);
	$produtos = json_decode($produtos);
	$listaProdutos = '';
	for ($i=0; $i < count($produtos); $i++) {
		$listaProdutos .= $produtos[$i] . ',';
	}
	$listaProdutos = substr($listaProdutos,0, -1);


	if ($impressora == 'prix4') {
		//DEPARTAMENTO TAMANHAO 2 PADRAO 01
		$dd = '01';
		//DESRCRICAO LINHA 2 TAMANHO 25
		$desc2 = '                         ';
		//COD INFORMACAO EXTRA e IMAGEM TAMANHO 4 CADA PADRAO 0000
		$codInfoImagem = '0000000000';
		//COD INFO NUTRICIONAL TAMANHO 6 PADRAO 000000
		$codInfoNutricional = '000000';
		//DATA VALIDADE E EMBALAGEM 1 -> IMPRIME | 0 -> NAO IMPRIME CADA
		$datas = '00';
		//COD FORNECEDOR TAMANHO 4, LOTE TAMANHO 12, EAN13 TAMANHO 11, VERSAO PRECO TAMANHO 1, PADRAO VAZIO
		//SOM TAMANHO FRACIONADOR EXTRA1 E 2, COD CONSERVACAO TAMANHO 4 PADRAO 0000
		$codDiversos = '0000000000000001            000000000000000000000000';
		//COD EAN13 FORNECEDOR TAMANHO 12 PADRAO VAZIO
		//PERCENTUAL GLACIAMENTO TAMANHO 6 PADRAO 000000
		//DEPARTAMENTO ASSOCIADO 2 BITS POR DEPARTAMENTO COM | NO COMEÇO E FIM DA STRING CASO HOUVER DEPARTAMENTO
		//DESCRITIVO 3ª E 4ª LINHA TAMANHO 35 CADA PARDAO VAZIO
		//CAMPO EXTRA 3 E 4 E CODIGO MIDIA TAMANHO 6 PADRAO 000000
		//PRECO PROMOCIONAL TAMANHO 6 SEM PONTOU OU VIRGULA PARDAO VAZIO
		$codDiversos2 = '            000000                                                                      000000000000000000      ';
		//BALANCA SOLICITA FORNECEDOR 0 -> NAO | 1 -> SIM PADDRAO 1
		//COD FORNECEDOR ASSOCIADO TAMANHO 6 POR FORNECEDOR | NO COMECO E FIM DA STRING CASO HOUVER FORNECEDOR
		//BALANCA SOLICITA TARA 0 -> NAO | 1 -> SIM PADRAO 1
		//BALANCA SEM ITEM ATIVO TAMANHO 2 POR FORNECEDOR | NO COMECO E FIM DA STRING CASO HOUVER BALANCA
		$solicitacoes = '11';
		//FECHAR COM \R\N
		$fecha = "\r\n";
		$itensMGV = "ITENSMGV.TXT";
		$infoNutri = "INFNUTRI.TXT";
		$txtItens = "TXITENS.TXT";
		$txinfo = "TXINFO.TXT";

		$qry = "SELECT P.idProduto, M.idMedida, M.flFracionado, C.idCodigo, P.stProduto, P.nrValidade, P.stDescricao,
		CASE WHEN P.flPromocao = '1' AND GETDATE() BETWEEN P.dtInicioPromocao AND P.dtFimPromocao THEN P.vrUnitarioPromocao ELSE P.vrUnitario END AS vrUnitario
		FROM prd_Produtos P
		INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
		INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
		WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($listaProdutos)
		ORDER BY P.stProduto";

		$res = mssql_query($qry);
		$listaProduto = '';
		$listaItens = '';
        $listaNutricional = '';
        $produto = '';
        $item = '';
        $info = '';
		while ($arr = mssql_fetch_assoc($res)) {
			$item .= "0100";
			//DEPARTAMENTO TAMANHAO 2 PADRAO 01
			$produto .= $dd;

			//TIPO TAMANHO 1  0 -> FRACIONADO | 1 -> INTEIRO
			if ($arr['flFracionado'] == 1) {
				$item .= '0';
				$produto .= '0';
			}else{
				$item .= '1';
				$produto .= '1';
			}

			//CODIGO DO PRODUTO TAMANHO 6
			if (strlen($arr['idCodigo']) < 6) {
				$arr['idCodigo'] = str_pad($arr['idCodigo'], 6, '0', STR_PAD_LEFT);
			}
			$item .= $arr['idCodigo'];
			$produto .= $arr['idCodigo'];
			$info .= $arr['idCodigo'];

			//PRECO TAMANHO 6 SEM VIRGULA OU PONTO 2 CASAS DECIMAIS
			$arr['vrUnitario'] = number_format($arr['vrUnitario'], 2, "", "");
			if (strlen($arr['vrUnitario']) > 6) {
				$arr['vrUnitario'] = substr($arr['vrUnitario'], 0, 6);
			}
			if (strlen($arr['vrUnitario']) < 6) {
				$arr['vrUnitario'] = str_pad($arr['vrUnitario'], 6, '0', STR_PAD_LEFT);
			}
			$item .= $arr['vrUnitario'];
			$produto .= $arr['vrUnitario'];

			//VALIDADE TAMANHO 3
			if (strlen($arr['nrValidade']) > 3) {
				$arr['nrValidade'] = substr($arr['nrValidade'], 0, 3);
			}
			if (strlen($arr['nrValidade']) < 3) {
				$arr['nrValidade'] = str_pad($arr['nrValidade'], 3, '0', STR_PAD_LEFT);
				if ($arr['nrValidade'] != 0) {
					$datas = '11';
				}
				else{
					$datas = '01';
				}
			}
			$item .= $arr['nrValidade'];
			$produto .= $arr['nrValidade'];

			//DESRCRICAO LINHA 1 TAMANHO 25
			$arr['stProduto'] = strtoupper(utf8_encode($arr['stProduto']));
			if (strlen($arr['stProduto']) > 25) {
				$arr['stProduto'] = substr($arr['stProduto'], 0, 25);
			}
			if (strlen($arr['stProduto']) < 25) {
				$arr['stProduto'] = str_pad($arr['stProduto'], 25, ' ', STR_PAD_RIGHT);
			}

			if ($adicional == 'I')
			{
				$arr['stDescricao'] = cleanString($arr['stDescricao']);

//				if (strlen($arr['stDescricao']) > 250){
//					$arr['stDescricao'] = substr($arr['stDescricao'], 0, 249);
//				}
//				else{
//					$arr['stDescricao'] = str_pad($arr['stDescricao'], 250, " ", STR_PAD_RIGHT);
//				}
//				$arr['stDescricao2'] = substr($arr['stDescricao'], 0, 25);
			}

            $observacao = '';
            $observacao = str_pad($observacao, 100, " ", STR_PAD_RIGHT);

			$item .= $arr['stProduto'].$desc2.$fecha;
			$info .= $observacao.$arr['stDescricao'].$fecha;
			$produto .= $arr['stProduto'].$codInfoImagem;
			// $produto .= $arr['stProduto'].$desc2.$codInfoImagem;

			$qryChk = "SELECT * FROM prd_TabelasNutricionais WHERE idProduto = '".$arr['idProduto']."'";
			$rs = mssql_query($qryChk);
			$ar = mssql_fetch_array($rs);
			$codInfoNutricional = "000000";
            $writeinfnutri = false;
            if ($ar[0])
			{
				//MODELO NUTRICIONAL
				//N + 6 DIGITOS DE CODIGO DA INF NUTRICIONAL
				//4 DIG PORCAO
				//1 DIG TIPO DA PORCAO (G=0, ML = 1, UN = 2)
				//2 DIG QTD DA MEDIDA CASEIRA
				//1 PORCAO CASEIRA (1/2, 3/4, VER EM CADASTRO DE PRODUTOS)
				//2 DIG SELECT MEDIDA CASEIRA(VER TABELA NUTRICIONAL EM CADASTRO DE PRODUTOS)
				//1 DIG (0 CONTEM, 1 N CONTEM) + 3 DIG KCAL
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG CARBOIDRATOS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG PROTEINAS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG GORDURAS TOTAIS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG GORDURAS SATURADAS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG GORDURAS TRANS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 2 DIG FIBRAS
				//1 DIG (0 CONTEM, 1 N CONTEM) + 4 DIG  SODIO + DIG 0
				$writeinfnutri = true;


				$codInfoNutricional = str_pad($arr['idProduto'], 6, "0", STR_PAD_LEFT);
				$nrQuantidade = str_pad($ar['nrQuantidade'], 4, "0", STR_PAD_LEFT);
				$nrUnidadePorcao = $ar['nrUnidadePorcao'];
				$nrParteInteiraMedidaCaseira = str_pad($ar['nrParteInteiraMedidaCaseira'], 2, "0", STR_PAD_LEFT);
				$nrParteDecimalMedidaCaseira = $ar['nrParteDecimalMedidaCaseira'];
				$nrMedidaCaseira = str_pad($ar['nrMedidaCaseira'], 2, "0", STR_PAD_LEFT);
				$nrValorEnergetico = str_pad($ar['nrValorEnergetico'], 4, "0", STR_PAD_LEFT);
				$nrCarboidratos = str_pad(number_format($ar['nrCarboidratos'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrProteinas = str_pad(number_format($ar['nrProteinas'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrGordurasTotais = str_pad(number_format($ar['nrGordurasTotais'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrGordurasSaturadas = str_pad(number_format($ar['nrGordurasSaturadas'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrGordurasTrans = str_pad(number_format($ar['nrGordurasTrans'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrFibraAlimentar = str_pad(number_format($ar['nrFibraAlimentar'], 0, "", ""), 3, "0", STR_PAD_LEFT);
				$nrSodio = str_pad(number_format($ar['nrSodio'], 0, "", ""), 5, "0", STR_PAD_LEFT);

				$listaNutricional .= "N".$codInfoNutricional.$nrQuantidade.$nrUnidadePorcao.$nrParteInteiraMedidaCaseira.$nrParteDecimalMedidaCaseira.$nrMedidaCaseira.$nrValorEnergetico.$nrCarboidratos.$nrProteinas.$nrGordurasTotais.$nrGordurasSaturadas.$nrGordurasTrans.$nrFibraAlimentar.$nrSodio."0\r\n";
			}

			// $body2 .= $stProduto."0000000000".$idTabelaNutricional."110000000000000000000000000000000000000000000000000000000000000000\r\n";
			$produto .= $codInfoNutricional.$datas.$codDiversos.$codDiversos2.$solicitacoes;
			$produto .= $fecha;
			$listaProduto .= $produto;
			$listaItens .= $item;
			$item = '';
			$produto = '';

		}

		@unlink($txtItens);
		$fopen = @fopen($txtItens, "w") or $erro = true;
		@fwrite($fopen, $listaItens) or $erro = true;
		@fclose($fopen) or $erro = true;

		@unlink($itensMGV);
		$fopen = @fopen($itensMGV, "w") or $erro = true;
		@fwrite($fopen, $listaProduto) or $erro = true;
		@fclose($fopen) or $erro = true;

		if ($writeinfnutri) {
			@unlink($infoNutri);
			$fopen = @fopen($infoNutri, "w") or $erro = true;
			@fwrite($fopen, $listaNutricional) or $erro = true;
			@fclose($fopen) or $erro = true;


            @unlink($txinfo);
            $fopen = @fopen($txinfo, "w") or $erro = true;
            @fwrite($fopen, $info) or $erro = true;
            @fclose($fopen) or $erro = true;
		}
	}else if($impressora == 'platina'){
		$fileName = "CADTXT.TXT";

		$sql =  "SELECT M.idMedida, C.idCodigo, P.stProduto, P.nrValidade, M.flFracionado,
		CASE
		WHEN P.flPromocao = '1' AND GETDATE() BETWEEN P.dtInicioPromocao AND P.dtFimPromocao THEN P.vrUnitarioPromocao
		ELSE P.vrUnitario
		END AS vrUnitario
		FROM prd_Produtos P
		INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
		INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
		WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($listaProdutos)
		ORDER BY P.stProduto";
		// var_dump($sql);
		$res = mssql_query($sql);

		$body = "";

		while ($arr = mssql_fetch_array($res))
		{
			for ($x=0; $x < (6 - strlen($arr['idCodigo'])); $x++)
				$body .= "0";


			$body .= $arr['idCodigo'];


			if ($arr['flFracionado'] == 1){
				$body .= "P";
			}else{
				$body .= "U";
			}

			$stProduto = strtoupper($arr['stProduto']);
		// $stProduto = removeInvalidBalChars($stProduto);

			if (strlen($stProduto) < 22){
				$body .= $stProduto;

				for ($x=0;$x<(22-strlen($stProduto));$x++)
					$body .= " ";
			}else{
				$stProduto = substr($stProduto, 0, 22);
				$body .= $stProduto;
			}

			$vrUnitario = number_format($arr['vrUnitario'], 2, "", "");

			for ($x=0;$x<(7-strlen($vrUnitario));$x++)
				$body .= "0";

			$body .= $vrUnitario;

			for ($x=0;$x<(3-strlen($arr['nrValidade']));$x++)
			{
				$body .= "0";
			}

			$body .= $arr['nrValidade'];

			$body .= "\r\n";
		}

		@unlink($fileName);
		$fopen = @fopen($fileName, "w") or $erro = true;
		@fwrite($fopen, $body) or $erro = true;
		@fclose($fopen) or $erro = true;

		$fileName2 = "SETORTXT.TXT";

		$sql =  "SELECT S.stSetor, C.idCodigo FROM prd_Produtos P
		INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
		INNER JOIN prd_Setores S ON P.idSetor = S.idSetor
		INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
		WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($listaProdutos)
		ORDER BY P.stProduto";

		$res = mssql_query($sql);

		$body = "";
		$nrIndice = (-1);

		while ($arr = mssql_fetch_array($res))
		{
			if (strlen($stSetor) < 12)
			{
				$body .= $stSetor;

				for ($x=0;$x<(12-strlen($stSetor));$x++)
				{
					$body .= " ";
				}
			}
			else
			{
				$stSetor = substr($stSetor, 0, 12);

				$body .= $stSetor;
			}

			for ($x=0;$x<(6-strlen($arr['idCodigo']));$x++)
			{
				$body .= "0";
			}

			$body .= $arr['idCodigo'];

			$nrIndice++;

			for ($x=0;$x<(4-strlen($nrIndice));$x++)
			{
				$body .= "0";
			}

			$body .= $nrIndice;

			$body .= "000";

			$body .= "\r\n";
		}

		@unlink($fileName2);
		$fopen = @fopen($fileName2, "w") or $erro = true;
		@fwrite($fopen, $body) or $erro = true;
		@fclose($fopen) or $erro = true;

		$filenameNutri = 'NUTRI.TXT';

		$sqlNutri = "SELECT
		a.idProduto,a.nrQuantidade,
		case
		a.nrUnidadePorcao
		when 0 then 'g'
		when 1 then 'ml'
		when 2 then 'un'
		else ''
			end as medida,
		a.nrValorEnergetico as vrCalorico,
		('0000') as PerCalorico,
		a.nrCarboidratos,
		('0000') as PerCarboidratos,
		a.nrProteinas,
		('0000') as PerProteinas,
		a.nrGordurasTotais,
		('0000') as PerGordurasTotais,
		a.nrGordurasSaturadas,
		('0000') as PerGordurasSaturadas,
		'00000' as colesterol,
		'0000' as Percolesterol,
		a.nrFibraAlimentar,
		('0000') as PerFibraAlimentar,
		('*****') as calcio,
		('****') as PercCalcio,
		('*****') as ferro,
		('****')  as PercFerro,
		a.nrSodio,
		('0000') as PercSodio
		FROM prd_TabelasNutricionais a
		inner join prd_produtos b on b.idProduto = a.idProduto";
		$rsnutri = mssql_query($sqlNutri);
		while ($row = mssql_fetch_array($rsnutri)) {

         /*
         * informações de importação para tabela nutricional
         * FILIZOLA PLATINA - LAYOUT PARA RDC 360
         * Observação 1:
            O campos de percentagem podem ser preenchidos com qualquer valor
            numérico, pois as percentagens são calculadas automaticamente pelo Smart. Eles foram
            mantidos por compatibilidade com o aplicativo anterior, o TSC.
         * configuração campo código
         */
            $str1 = $row['idProduto'];
            $count = strlen($str);
            $qtdCpCodigo = 6;
            $increase = $qtdCpCodigo - $count ;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $codigo = $incremento.$str1;

            /** configuração campo descrição*/
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str2 = $row['nrQuantidade'].$row['medida'];
            $str2 = str_replace(' ','_', $str2);
            $count = strlen($str2);
            $qtdCpDesc = 35;
            $increase = $qtdCpDesc - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $desc = $str2.$incremento;


            /** configuração campo vrCalorico*/
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str3 = $row['vrCalorico'];
            $count = strlen($str2);
            $qtdCpvrCal = 5;
            $increase = $qtdCpvrCal - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $vrCalorico = $incremento.$str3;

            /** configuração campo vrCaloricoPersentual */
            $PerCalorico = $row['PerCalorico'];

            /** configuração campo nrCarboidratos */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str5 = $row['nrCarboidratos'];
            $count = strlen($str2);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $nrCarboidratos = $incremento.$str5;

            /** configuração campo PerCarboidratos */
            $PerCarboidratos = $row['PerCarboidratos'];

            /** configuração campo nrProteinas */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str7 = $row['nrProteinas'];
            $count = strlen($str2);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $nrProteinas = $incremento.$str7;

            /** configuração campo PerProteinas */
            $PerProteinas = $row['PerProteinas'];

            /** configuração campo nrGordurasTotais */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str9 = $row['nrGordurasTotais'];
            $count = strlen($str2);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $nrGordurasTotais = $incremento.$str9;

            /** configuração campo PerGordurasTotais */
            $PerGordurasTotais = $row['PerGordurasTotais'];

            /** configuração campo nrGordurasSaturadas */
            $count = NULL;
            $incremento = NULL;
            $increase = NULL;

            $str11 = $row['nrGordurasSaturadas'];
            $count = strlen($str2);
            $qtdCpvrCarb = 5;
            $increase = $qtdCpvrCarb - $count;
            for ($index = 0; $index < $increase; $index++) {
            	$incremento .= "0" ;
            }
            $nrGordurasSaturadas = $incremento.$str11;

            /** configuração campo PerGordurasSaturadas */
            $PerGordurasSaturadas = $row['PerGordurasSaturadas'];

            /*configuração campo colesterol*/
            $colesterol = $row['colesterol'];

            /*configuração campo Percolesterol*/
            $Percolesterol = $row['Percolesterol'];

            /*configuração campo nrFibraAlimentar*/
            $nrFibraAlimentar = $row['nrFibraAlimentar'];

            /*configuração campo PerFibraAlimentar*/
            $PerFibraAlimentar = $row['PerFibraAlimentar'];

            /*configuração campo calcio,PercCalcio,ferro,PercFerro,nrSodio,PercSodio*/
            $calcio = $row['calcio'] ;
            $PercCalcio = $row['PercCalcio'];
            $ferro = $row['ferro'];
            $PercFerro = $row['PercFerro'];
            $nrSodio = $row['nrSodio'];
            $PercSodio = $row['PercSodio'];

            $body = $codigo.$desc.$vrCalorico.$PerCalorico.$nrCarboidratos.$PerCarboidratos.
            $nrProteinas.$PerProteinas.$nrGordurasTotais.$PerGordurasTotais.
            $nrGordurasSaturadas.$PerGordurasSaturadas.$colesterol.$Percolesterol.
            $nrFibraAlimentar.$PerFibraAlimentar.$calcio.$PercCalcio.$ferro.
            $PercFerro.$nrSodio.$PercSodio."\r\n";
        }

        $fopen = @fopen($filenameNutri, "w") or $erro = true;
        @fwrite($fopen, $body) or $erro = true;
        @fclose($fopen) or $erro = true;
    }

    if (!$erro) {
    	echo retornaJson(true, '');
    }else{
    	echo retornaJson(false, '');
    }
}
?>
