<?php

namespace App\Entities\Nati\ExportProductsScale;


class ExportProducts
{
    public $productsIds;
    public $nutritionalInformation;
    public $additionalInformation;
    public $fileGenerator;

    public function __construct($request, FileGenerator $fileGenerator)
    {
        $this->productsIds = $request['productsIds'];
        $this->nutritionalInformation = $request['nutritionalInformation'];
        $this->additionalInformation = $request['additionalInformation'];
        $this->fileGenerator = $fileGenerator;
    }

    public function generateFiles()
    {
        $additionalInformation = $this->hasAdditionalInformation();
        $response = $this->fileGenerator->generateItensFile($this->productsIds, $additionalInformation);
        $this->hasNutritionalInformation();
    }

    public function hasNutritionalInformation()
    {
        if($this->nutritionalInformation) {
            $this->fileGenerator->generateNutritionalInformationFile($this->productsIds);
            return;
        }
        return;
    }

    public function hasAdditionalInformation()
    {
        if($this->additionalInformation) {
            return $additionalInformation = true;
        }
        return $additionalInformation = false;
    }
}
