<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class StockItemsMovimentation.
 *
 * @package namespace App\Entities;
 */
class StockItemsMovimentation extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'est_ItensMovimentacao';
    protected $primaryKey = ['idItem', 'idMovimentacao', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idItem',
        'idMovimentacao',
        'idAbertura',
        'idProduto',
        'nrQuantidade',
        'vrValor',
        'nrQuantidadeConversao',
        'stMedidaConversao',
        'dtAlteracao',
    ];

}
