<?php

namespace App\Events;

use App\Entities\Manager;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PosOpened
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $pos;

    /**
     * Create a new event instance.
     *
     * @param Manager $pos
     */
    public function __construct(Manager $pos)
    {
        $this->pos = $pos;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
