<?php

namespace App\Http\Controllers\Financeiro;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContaBancariaCreateRequest;
use App\Services\ContaBancariaService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Financeiro\ContaBancariaUpdateRequest;


class ContaBancariasController extends Controller
{

    protected $service;


    public function __construct(ContaBancariaService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try
        {
            $contaBancarias = $this->service->get();

            return response()->json($contaBancarias);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ContaBancariaCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(ContaBancariaCreateRequest $request)
    {
        try {
            $contaBancaria = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Bandeiras created',
                'data' => $contaBancaria
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        try
        {
            $contaBancarias = $this->service->getById($id);

            return response()->json([
                'data' => $contaBancarias,
            ],200);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ContaBancariaUpdateRequest $request
     * @param  string            $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(ContaBancariaUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Conta Bancaria Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $response = $this->service->delete($id);
            return response()->json([
                'message' => 'Conta Bancaria removida',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }

    }
}
