<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\ContasPagar;
use App\Http\Controllers\Controller;
use App\Services\ContasPagarService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\ContasPagarCreateRequest;
use App\Http\Requests\ContasPagarUpdateRequest;
use Yajra\Datatables\Datatables;


class ContasPagarsController extends Controller
{

    protected $service;

    public function __construct(ContasPagarService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {
            $contaPagar = $this->service->get();

            return response()->json([
                'data' => $contaPagar,
            ],200);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

    public function dataTable()
    {
        $contasPagar = ContasPagar::with('fornecedores')->where('flAtivo', '=', 1);

        return Datatables::of($contasPagar)
            ->editColumn('dtLancamento', function ($contasPagar) {
                return date("d/m/Y", strtotime($contasPagar['dtLancamento']));
            })
            ->editColumn('dtVencimento', function ($contasPagar) {
                return date("d/m/Y", strtotime($contasPagar['dtVencimento']));
            })
            ->addColumn('action', function($contaPagar){
                return '
                  <a onClick="editarContaPagar('.$contaPagar->idContasPagar.','.$contaPagar->idFornecedor.')" class="col-sm-2 col-sm-offset-2 col-md-offset-2 col-md-4" style="cursor:pointer"><span class="glyphicon glyphicon-edit" style="font-size:1.5em"></span></a>
                  <a onClick="deletarContaPagar('.$contaPagar->idContasPagar.','.$contaPagar->idFornecedor.')" class="col-sm-2 col-md-4" style="cursor:pointer"><span class="glyphicon glyphicon-remove" style="font-size:1.5em"></span></a>';
            })->make(true);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ContasPagarCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(ContasPagarCreateRequest $request)
    {

        try {
            $contasPagar = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Contas a Pagar created',
                'data' => $contasPagar
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function view($idContasPagar, $idFornecedor)
    {
        try
        {
            $contasPagar = $this->service->getById($idContasPagar, $idFornecedor);

            return response()->json([
                'data' => $contasPagar,
            ],200);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ContasPagarUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(ContasPagarUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Contas a pagar Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $response = $this->service->delete($id);
            return response()->json([
                'message' => 'Conta a pagar removida',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }

    }
}
