<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\TipoFormaPagamentoService;
use Illuminate\Support\Facades\Cache;

class TipoFormaPagamentoController extends Controller
{

    /**
     * @var TipoFormaPagamentoService
     */
    protected $service;

    public function __construct(TipoFormaPagamentoService $service) {

        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

        if (Cache::tags(['ListaTipoFormaPagamento'])->has('all')) {
            return Cache::tags(['ListaTipoFormaPagamento'])->get('all');
        }else{
            $response = $this->service->get();
            Cache::tags(['ListaTipoFormaPagamento'])->put('all', $response, 1440);
            return response()->json($response);
        }
    }
}
