<?php

namespace App\Http\Resources\Nati;

use Illuminate\Http\Resources\Json\Resource;

class ClosureResource extends Resource
{

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */


    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'id_pdv' => $this->id_pdv,
            'operator' => $this->operator,
            'total_received' => (float)$this->total,
            //total de vendas
            'total_sales' => (float)$this->recebimentos()->where('active', true)
                ->whereIn('id_type_payment', [1, 2, 4, 6, 12, 14])->sum('vrFormaPagamento'),
            'open_date' => $this->open_date,
            'close_date' => $this->close_date,
            'open' => $this->open,
            'change_closing' => $this->change_closing,
            'conference' => $this->conference,
            'total_customers' => $this->total_customers,
            //transações
            'quantity_total' => $this->quantity_total,
            'note' => $this->note,
            'update_date' => $this->update_date,
            'card_payments' => $this->cardPayments(),
            'quantity_sales_cancellations' => $this->vendasTemp()->where('active', false)->count(),
            'money' => [
                'open_value' => (float)$this->open_value,
                'money_system' => (float)$this->recebimentos()->where('active', true)
                    ->where('id_type_payment', 1)->sum('vrFormaPagamento'),
                'sangria' => (float)$this->sangrias()->where('active', true)
                    ->where('vrSangria', '>', 0)->sum('vrSangria'),
                'supplies' => (float)$this->sangrias()->where('active', true)
                        ->where('vrSangria', '<', 0)->sum('vrSangria') * -1,
                'voucher' => (float)$this->voucher()->where('active', true)->sum('vrVaucher'),
                'payment_conta_assinada' => (float)$this->cliPagamento()
                    ->where('active', true)->where('id_type_payment', 1)->sum('vrPagamento'),
            ],
            'release' => [
                'despesas' => (float)$this->despesas()->where('active', true)->sum('vrDespesa'),
                'value_card' => (float)$this->recebimentos()->where('id_type_payment', 2)
                    ->where('active', true)->sum('vrFormaPagamento'),
                'service_table' => (float)$this->vendasTemp()->where('active', true)->sum('vrAcrescimo'),
                'delivery_tax' => (float)$this->vendasTemp()->where('active', true)
                    ->where('delivery', true)->sum('vrDesconto'),
                'repique' => (float)$this->repiques()->where('active', true)->sum('vrRepique'),
                //Pagamentos Efetuados em Contas assinadas
//                'received_conta_assinada' => (float)$this->recebimentos()
//                    ->whereIn('id_type_payment', [12, 14])
//                    ->where('active', true)->sum('vrFormaPagamento'),
                //Todos depositos efetuados de conta assinada
                'payment_conta_assinada' => (float)$this->cliPagamento()
                    ->where('active', true)->sum('vrPagamento'),
            ]
        ];
    }
}
