<?php


namespace App\Imports;


use App\Entities\Nati\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromArray;

class ProductsExport implements FromArray
{

    public function array() : array
    {
        // $products = Product::selectRaw(
        //     'prd_Produtos.idProduto as id,
        //         MIN(prd_Codigos.idCodigo) as codigo,
        //         prd_Produtos.stProdutoAbreviado as descricao,
        //         prd_Categorias.stCategoria as categoria,
        //         prd_SubCategorias.stSubCategoria as subcategoria,
        //         prd_Medidas.stMedida as medida,
        //         prd_Produtos.nrNCm as ncm,
        //         prd_produtos.vrCusto as custo,
        //         prd_Produtos.vrUnitario as preco,
        //         prd_Setores.stSetor as setor,
        //         prd_Aliquotas.stAliquota as aliquota,
        //         prd_Produtos.dtUltimaAlteracao as alteracao,
        //         prd_Produtos.flAtivo as ativo'
        // )
        //     ->join('prd_Categorias', 'prd_Produtos.idCategoria', '=', 'prd_Categorias.idCategoria')
        //     ->join("prd_SubCategorias", function ($join) {
        //         $join->on("prd_SubCategorias.idCategoria", "=", "prd_Produtos.idCategoria")
        //             ->on("prd_SubCategorias.idSubCategoria", "=", "prd_Produtos.idSubCategoria");
        //     })
        //     ->join('prd_Medidas', 'prd_Produtos.idMedida', '=', 'prd_Medidas.idMedida')
        //     ->join('prd_Setores', 'prd_Produtos.idSetor', '=', 'prd_Setores.idSetor')
        //     ->join('prd_Aliquotas', 'prd_Produtos.idAliquota', '=', 'prd_Aliquotas.idAliquota')
        //     ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_Codigos.idProduto')

        //     ->where('prd_Produtos.flAtivo', true)
        //     ->where('prd_Codigos.idCodigo', '<>', '-100')
        //     ->orderBy('prd_Produtos.stProdutoAbreviado', 'ASC')
        //     ->groupBy(['prd_Produtos.idProduto',
        //         'prd_Produtos.stProdutoAbreviado',
        //         'prd_Categorias.stCategoria',
        //         'prd_SubCategorias.stSubCategoria',
        //         'prd_Medidas.stMedida',

        //         'prd_Aliquotas.Codigo',
        //         'prd_Produtos.nrNCm',
        //         'prd_Produtos.vrCusto',
        //         'prd_Produtos.vrUnitario',
        //         'prd_Setores.stSetor',
        //         'prd_Aliquotas.stAliquota',
        //         'prd_Produtos.dtUltimaAlteracao',
        //         'prd_Produtos.flAtivo'])->get()->toArray();
        $products = DB::select("
        select p.idProduto as 'id', MIN(c.idCodigo) as 'codigo', p.stProdutoAbreviado as 'descricao', cat.stCategoria as 'categoria', sub.stSubCategoria as 'sub-categoria', m.stMedida as 'medida', p.nrNcm as 'ncm', p.vrCusto as 'custo', p.vrUnitario as 'preco', s.stSetor as 'setor', a.stAliquota as 'aliquota', p.dtUltimaAlteracao as 'ultima-alteracao'
        from prd_produtos p
        join prd_categorias cat on cat.idCategoria = p.idCategoria
        join prd_SubCategorias sub on sub.idCategoria = p.idCategoria and sub.idSubCategoria = p.idSubCategoria
        join prd_medidas m on m.idMedida = p.idMedida
        join prd_Setores s on s.idSetor = p.idSetor
        join prd_Aliquotas a on a.idAliquota = p.idAliquota
        join prd_Codigos c on c.idProduto = p.idProduto
        where p.flAtivo = 1
        and c.idCodigo <> '-100'
        group by p.idProduto, codigo, p.stProdutoAbreviado, cat.stCategoria, sub.stSubCategoria, m.stMedida, p.nrNcm, p.vrCusto, p.vrUnitario, s.stSetor, a.stAliquota, p.dtUltimaAlteracao
        order by p.stProdutoAbreviado ASC
        ");

        array_unshift($products, [
            'id',
            'codigo',
            'descricao',
            'categoria',
            'sub-categoria',
            'medida',
            'ncm',
            'custo',
            'preco',
            'setor',
            'aliquota',
            'ultima-alteracao'
        ]);

        return $products;
    }

//    public function columnFormats(): array
//    {
////        return [
////            'a' =>
////        ]
//    }
}
