<?php

namespace App\Repositories\Mobyo;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Mobyo\MobyoPaymentRepository;
use App\Entities\Mobyo\MobyoPayment;
use App\Validators\Mobyo\MobyoPaymentValidator;

/**
 * Class MobyoPaymentRepositoryEloquent.
 *
 * @package namespace App\Repositories\\Mobyo;
 */
class MobyoPaymentRepositoryEloquent extends BaseRepository implements MobyoPaymentRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return MobyoPayment::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return MobyoPaymentValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
