<?php

namespace App\Repositories;

use App\Entities\SaleTemp;
use App\Validators\SaleTempValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class VendaTempRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class SaleTempRepositoryEloquent extends BaseRepository implements SaleTempRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return SaleTemp::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return SaleTempValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
