<?php


namespace App\Services\Delivery;


use App\Entities\Nati\Customer;
use App\Repositories\PhoneRepository;
use App\Services\CEPService;
use App\Services\PhoneService;
use Carbon\Carbon;
use App\Validators\CustomerValidator;
use App\Repositories\CustomerRepository;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Prettus\Validator\Contracts\ValidatorInterface;

class CustomerService
{
    protected $repository;
    protected $validator;
    protected $cep;
    protected $phoneRepository;
    protected $user;
    private $phoneService;

    public function __construct(CustomerRepository $repository, CustomerValidator $validator, CEPService $cep, PhoneRepository $phoneRepository, PhoneService $phoneService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->cep = $cep;
        $this->phoneRepository = $phoneRepository;
        $this->phoneService = $phoneService;
    }

    public function get($request)
    {
//        $key = md5(json_encode($request));
//        if (Cache::tags(['ListaCustomer'])->has($key)) {
//            return Cache::tags(['ListaCustomer'])->get($key);
//        } else {
            $order = !$request['order'] ? 'ASC' : Str::upper($request['order']);
            $sort = $request['sort'] == '' ? 'idCliente' : $request['sort'];
            $response = Customer::with('telefones')
            ->select('*')
                ->where('dlv_Clientes.flAtivo', true)
                ->where('dlv_Clientes.idCliente', '>', 0)
                ->where(function ($query) use ($request) {
                    if (isset($request['filter']) and strlen($request['filter']) > 0 and $request['filter'] != null)
                        $query->where('stCliente', 'LIKE', '%' . $request['filter'] . '%')
                            ->orWhere('stNomeFantasia', 'LIKE', '%' . $request['filter'] . '%');
                })
                ->orderBy($sort, $order)
                ->paginate($request['limit'], $request['page']);

//            Cache::tags(['ListaCustomer'])->put($key, $response, 1440);
            return $response;
//        }
    }

    public function filter($request)
    {
        return Customer::leftJoin('dlv_Telefones', 'dlv_clientes.idCliente', '=', 'dlv_Telefones.idCliente')
            ->where('dlv_clientes.flAtivo', true)
            ->where(function ($query) use ($request) {
                $query->where('nrTelefone', 'LIKE', '%' . $request . '%')
                    ->orWhere('stCliente', 'LIKE', '%' . $request . '%');
            })
            ->limit(10)
            ->get()
            ->map(function ($item) {
                return [
                    'stCliente' => $item->stCliente,
                    'nrTelefone' => $item->nrTelefone,
                    'idCliente' => $item->idCliente
                ];
            });
    }

    public function getById($id)
    {
        $user = $this->repository->with(['endereco', 'telefones', 'vendas'])->find($id);
        if ($user->flContaAssinada) {
            $subquery = "(SELECT C.vrLimite, E.dtData, E.idCliente, ((E.vrTotal + E.vrQuitado) * -1) as vrSoma FROM cli_Extrato E INNER JOIN dlv_Clientes C ON C.idCliente = E.idCliente WHERE E.flAtivo = '1' UNION SELECT C.vrLimite, P.dtData, P.idCliente, P.vrPagamento as vrSoma FROM cli_Pagamento P INNER JOIN dlv_Clientes C ON C.idCliente = P.idCliente) AS X";
            $saldo = DB::select('SELECT idCliente, SUM(vrSoma) as saldo FROM ' . $subquery . " WHERE idCliente = $id GROUP BY idCliente");
            if ($saldo) {
                $user->vrSaldo = $saldo[0]->saldo;
            }
        }
        return $user;
    }

    public function getCEP($data)
    {
        return !isset($data['endereco']['idCEP']) || strlen($data['endereco']['idCEP']) == 0 || $data['endereco']['idCEP'] == "0"
            ? 0
            : $this->cep->getByCEP($data['endereco']['stCEP'])->idCEP;
    }

    public function insert($data)
    {
        $data['stOperador'] = auth()->user()->stApelido;
        $data['stOperadorUltimaAlteracao'] = ' ';
        $data['vrSaldo'] = 0;
        $data['vrSaldoPagamento'] = 0;
        $data['nrTipoTerceiro'] = 2;
        $data['dtUltimaAlteracao'] = Carbon::now();
        $data['dtAlteracao'] = Carbon::now();
        $data['flAtivo'] = true;
        $data['flBloqueado'] = false;
        $data['flFuncionario'] = false;
        $data['sync'] = false;
        $data['stSexo'] = ' ';


        $contact = $data['telefones'];

        $data['telefones'] = '';
        $data['dtCadastro'] = Carbon::now();

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $response = $this->repository->create($data);
        if ($contact) {
            $this->phoneService->insert($contact);
        }

        return $response;
    }

    public function update($data, $id)
    {
        $data['stOperador'] = auth()->user()->stApelido;
        $data['stOperadorUltimaAlteracao'] = ' ';
        $data['vrSaldo'] = 0;
        $data['dtUltimaAlteracao'] = Carbon::now();
        $data['dtAlteracao'] = Carbon::now();
        $data['nrNumero'] = isset($data['nrNumero']) ? $data['nrNumero'] : 0;
        $data['stSexo'] = 'I';

        $contact = $data['telefones'];

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        $response = $this->repository->update($data, $id);

        if ($contact) {
            $this->phoneService->update($contact, $id);
        }

        return $response;
    }

    public function getNextId()
    {
        return Customer::max('idCliente') + 1;
    }

    public function delete($id)
    {
        $response = $this->repository->find($id)->update(['flAtivo' => false]);

        return $response;
    }

    public function getPhoneById($idCliente)
    {
        $response = $this->phoneRepository->findWhere(['idCliente' => $idCliente]);

        return $response;
    }
}
