<?php


namespace App\Services\Nati;


use App\Entities\Delivery\Order;
use App\Entities\Manager;
use App\Entities\SalesByMonthView;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardService
{
    public function loadInit()
    {
        $query = 'SELECT main, delivery, geral FROM nat_Modules';
        $main = DB::select($query);

        $dlv = $main->delivery != null ? explode(';', base64_decode($main->delivery)) : [];
        $geral = explode(';', base64_decode($main->geral));
        $opt = explode(';', base64_decode($main->main));
        $result['options'] = $opt;
        $result['dlvOpt'] = $dlv;
        $result['geralOpt'] = $geral;
//        Manager::where(['flAberto' => false, 'flConferencia' => false])->get();

        $result['pedidos'] = Order::select('idAtendimento, dtAbertura, dtSaidaMotoboy, stStatus, idCliente')
            ->where('stStatus', 'S')
            ->orWhere(function($query){
                $query->where('stStatus','P')
                    ->where('flPago', 0);
            })
            ->orderBy($opt[3])
            ->get();

        return $result;
    }

    public function getSalesByMonth()
    {
        $now = Carbon::now();
        $currentDate = $now->year . '-' . str_pad($now->month, 2, '0', STR_PAD_LEFT) . '-' . $now->day;
        $limitMonth = 0;

        $result = SalesByMonthView::whereRaw("cast(dtData as date) >= DATEADD(month, -12, '$currentDate')")
                                    ->orderBy('dtData')
                                    ->get();
        return $result;
    }

    public function getTopProducts($request)
    {
        if(!$request->endDate) {
            $date = explode('/', $request->date);
            $month = $date[0];
            $year = $date[1];
            $measure = $request->measure;
            if($measure === 'kg') $queryFilter = ' where m.flFracionado = 1 ';
            if($measure === 'un') $queryFilter = ' where m.flFracionado = 0 ';
            if(!$measure || $measure === '' ) $queryFilter = ' ';
            return DB::select("
                select top 30 stProduto, i.qtd, i.total, i.idProduto, m.stMedida, m.flFracionado, i.unidades from prd_produtos p join (
                select sum(nrQuantidade) as qtd, sum(vrTotal) as total, idProduto, sum(1) as 'unidades' from cx_Itens where flAtivo = 1
                and year(dtData) = '$year'
                and month(dtData) = '$month'
                group by idProduto
                union
                select sum(nrQuantidade) as qtd, sum(vrTotal) as total, idProduto, sum(1) as 'unidades' from cx_itens_temp where flAtivo = 1
                and year(dtData) = '$year'
                and month(dtData) = '$month'
                group by idProduto) i
                on p.idProduto = i.idProduto
                join prd_Medidas as m on p.idMedida = m.idMedida"
                . $queryFilter .
                "group by p.stProduto, i.qtd, i.idProduto, i.total, m.stMedida, m.flFracionado
                order by i.qtd desc
            ");
        } else {
            $measure = $request->measure;
            if($measure === 'kg') $queryFilter = ' where m.flFracionado = 1 ';
            if($measure === 'un') $queryFilter = ' where m.flFracionado = 0 ';
            if(!$measure || $measure === '' ) $queryFilter = ' ';
            $date = Carbon::createFromFormat('d/m/Y', $request->date)->format('Y-m-d');
            $endDate = Carbon::createFromFormat('d/m/Y', $request->endDate)->format('Y-m-d');
            return DB::select("
                select top 30 stProduto, i.qtd, i.total, i.idProduto, m.stMedida, m.flFracionado, i.unidades from prd_produtos p join (
                select sum(nrQuantidade) as qtd, sum(vrTotal) as total, idProduto, sum(1) as 'unidades' from cx_Itens where flAtivo = 1
                and dtData between '$date 00:00:00' and '$endDate 23:59:59'
                group by idProduto
                union
                select sum(nrQuantidade) as qtd, sum(vrTotal) as total, idProduto, sum(1) as 'unidades' from cx_itens_temp
                where flAtivo = 1
                and dtData between '$date 00:00:00' and '$endDate 23:59:59'
                group by idProduto) i
                on p.idProduto = i.idProduto
                join prd_Medidas as m on p.idMedida = m.idMedida"
                . $queryFilter .
                "group by p.stProduto, i.qtd, i.idProduto, i.total, m.stMedida, m.flFracionado, i.unidades
                order by i.qtd desc
            ");
        }
    }

    public function getStatisticsByMonth($request)
    {
        $date = explode('/', $request->date);
        $month = $date[0];
        $year = $date[1];
        return SalesByMonthView::whereMonth('dtData', '=', $month)
                                ->whereYear('dtData', '=', $year)
                                ->get();
    }

    public function getSalesComparative($request)
    {
        $year = $request->year;
        $currentYear = SalesByMonthView::whereYear('dtData', '=', $year)
                                        ->orderBy('dtData')
                                        ->get();
        $lastYear = SalesByMonthView::whereYear('dtData', '=', $year - 1)
                                    ->orderBy('dtData')
                                    ->get();
        $res['current'] = $currentYear;
        $res['last'] = $lastYear;
        return $res;
    }

    public function getSalesBySegment($request)
    {
        $date = explode('/', $request->date);
        $month = $date[0];
        $year = $date[1];
        return DB::select("
        select top 10 s.stSetor, sum(i.total) as total from sales_item_list i
            join sales_list v on i.idAbertura = v.idAbertura and i.idVenda = v.idvenda
            join prd_codigos c on c.idCodigo = cast(i.codigo as nvarchar)
            join prd_Produtos p on c.idProduto = p.idProduto
            join prd_Setores s on s.idSetor = p.idSetor
            where v.flAtivo = 1
            and year(dtData) = '$year'
			and month(dtData) = '$month'
            group by s.stSetor
            order by total DESC
        ");
    }

    public function getCancelledSales($request)
    {
        $date = explode('/', $request->date);
        $month = $date[0];
        $year = $date[1];
        return DB::select("select count(1) as cancelledSales from sales_list where flAtivo = 0 and month(dtData) = '$month' and year(dtData) = '$year'");
    }

    public function getSalesByDay($request)
    {
        $date = explode('/', $request->date);
        $month = $date[0];
        $year = $date[1];
        return DB::select("select * from vw_sales_by_day where month(dtData) = '$month' and year(dtData) = '$year' order by dtData ASC");
    }
    public function getSalesByTime($request)
    {
        if(!$request->endDate) {
            $date = explode('/', $request->date);
            $month = $date[0];
            $year = $date[1];
            return DB::select("
                SELECT
                DATEPART(hour, dtData) AS hour,
                COUNT(*) AS total
                FROM sales_list
                WHERE month(dtData) = '$month' and year(dtData) = '$year'
                GROUP BY DATEPART(hour, dtData)
                ORDER BY DATEPART(hour, dtData)
            ");
        } else {
            $date = Carbon::createFromFormat('d/m/Y', $request->date)->format('Y-m-d');
            $endDate = Carbon::createFromFormat('d/m/Y', $request->endDate)->format('Y-m-d');
            return DB::select("
                SELECT
                DATEPART(hour, dtData) AS hour,
                COUNT(*) AS total
                FROM sales_list
                WHERE dtData between '$date 00:00:00' and '$endDate 23:59:59'
                GROUP BY DATEPART(hour, dtData)
                ORDER BY DATEPART(hour, dtData)
            ");
        }
    }
}
