<?php

namespace App\Services\Nati;

use App\Entities\Nati\Resposta;
use App\Repositories\Nati\RespostaRepository;
use App\Services\Service;
use App\Validators\Nati\RespostaValidator;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class RespostaService extends Service
{
    private $repository;
    private $validator;
    private $respostaProdutoService;
    private $respostaObservacaoService;

    /**
     * CategoriaService constructor.
     * @param RespostaRepository $repository
     * @param RespostaValidator $validator
     */
    public function __construct(RespostaRepository $repository, RespostaValidator $validator, RespostaProdutoService $respostaProdutoService, RespostaObservacaoService $respostaObservacaoService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->respostaProdutoService = $respostaProdutoService;
        $this->respostaObservacaoService = $respostaObservacaoService;
    }

    public function store($data, $idPergunta)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        if($data['type'] === 'product') {
            foreach($data['options'] as $option) {
                $respostaProduto = $this->respostaProdutoService->store($option);
                $arr = [
                    'idPergunta' => $idPergunta,
                    'idTipoResposta' => 1,
                    'flAtivo' => 1,
                    'dtAlteracao' => Carbon::now(),
                    'idRespostaProduto' => $respostaProduto->idRespostaProduto,
                    'idRespostaObservacao' => null,
                    'nrOrdem' => $option['nrOrdem']
                ];
                $respostasProduto[] = $respostaProduto;
                $respostas[] = $this->repository->create($arr);
            }

        }
        if($data['type'] === 'observation') {
            foreach($data['options'] as $option) {
                $arr = [
                    'idPergunta' => $idPergunta,
                    'idTipoResposta' => 2,
                    'flAtivo' => 1,
                    'dtAlteracao' => Carbon::now(),
                    'idRespostaProduto' => null,
                    'idRespostaObservacao' => $option['idObservacao'],
                    'nrOrdem' => $option['nrOrdem']
                ];
                $respostas[] = $this->repository->create($arr);
            }
        }
        return $respostas;
    }

    public function deleteByIdPergunta($idPergunta)
    {
        $respostas = $this->repository->findByField('idPergunta', $idPergunta);
        foreach($respostas as $resposta) {
            if($resposta->idTipoResposta === 1) $this->respostaProdutoService->deleteByIdRespostaProduto($resposta->idRespostaProduto);
            $resposta->delete();
        }

    }
}
